package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.socket.util.EkoGson.get
import com.ekoapp.ekosdk.EkoCategoryIds

class EkoCategoriesTypeConverter {
	@TypeConverter
	fun stringToEkoCategories(json: String?): EkoCategoryIds {
		return get().fromJson(json, EkoCategoryIds::class.java)
	}
	
	@TypeConverter
	fun ekoCategoriesToString(categories: EkoCategoryIds): String {
		return get().toJson(categories)
	}
}