package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "sub_channel_marker", primaryKeys = ["subChannelId"])
open class SubChannelMarkerEntity : EkoObject() {
    
    var subChannelId: String = ObjectId.get().toHexString()
    var channelId: String = ""
    var lastSegment : Int = 0

    override fun getId(): String {
        return subChannelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is SubChannelMarkerEntity
                && Objects.equal(subChannelId, other.subChannelId)
                && Objects.equal(channelId, other.channelId)
                && Objects.equal(lastSegment, other.lastSegment)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            subChannelId,
            channelId,
            lastSegment,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("subChannelId", subChannelId)
            add("channelId", channelId)
            add("lastSegment", lastSegment)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}