package com.amity.socialcloud.sdk.social.domain.story.markseen

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository
import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.social.data.story.StoryRepository
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import io.reactivex.rxjava3.schedulers.Schedulers
import org.joda.time.DateTime

class MarkStoryAsViewedUseCase {

    fun execute(story: AmityStory) {
        if (story.getState() != AmityStory.State.SYNCED) {
            return
        }
        val event = AnalyticsRepository().createAnalyticEvent(
            contentId = story.getStoryId(),
            contentType = "story",
            activityType = "view",
            syncPriority = AnalyticsEventSyncPriority.HIGH,
            deduplicationKey = story.getStoryId() + ".view",
        )
        AnalyticsService().captureEvent(event)

        val storyId = story.getStoryId()
        // don't use target from story but query target from cache to ensure up-to-date data
        val storyTarget =
            StoryTargetRepository().getStoryTarget(story.getTargetType(), story.getTargetId())
        if (storyTarget != null
            && story.getExpiresAt()?.isAfter((storyTarget.highestSeen ?: DateTime.now())) ?: false
        ) {
            StoryTargetRepository().updateStoryTargetLocalLastStorySeenExpiresAt(
                targetType = story.getTargetType(),
                targetId = story.getTargetId(),
                localLastStorySeenExpiresAt = story.getExpiresAt()
            ).andThen(StoryRepository().triggerStoryReload(storyId))
                .onErrorComplete()
                .subscribeOn(Schedulers.io())
                .subscribe()
        }

    }
}