package com.amity.socialcloud.sdk.social.data.community.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.CommunityEntity
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface CommunityQueryPagingDao : DynamicQueryStreamPagingDao<CommunityEntity> {

    @RawQuery(observedEntities = [CommunityEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommunityEntity>

    fun getCommunityPagingSource(
        keyword: String,
        categoryId: String,
        filter: AmityCommunityFilter,
        sortOption: AmityCommunitySortOption,
        isDeleted: Boolean?,
    ): PagingSource<Int, CommunityEntity> {
        val sortColumn = if(sortOption == AmityCommunitySortOption.DISPLAY_NAME) null else "createdAt"
        val order = if(sortOption == AmityCommunitySortOption.LAST_CREATED) AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "community",
                primaryKeyColumnName = "communityId",
                nonce = AmityNonce.COMMUNITY_LIST,
                sortColumn = sortColumn,
                order = order,
                dynamicQueryStreamKeyCreator = CommunityQueryKeyCreator(
                    keyword = keyword,
                    categoryId = categoryId,
                    filter = filter,
                    sortOption = sortOption,
                    isDeleted = isDeleted
                )
            )
        )
    }

}