package com.amity.socialcloud.sdk.core.domain.user

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import io.reactivex.rxjava3.core.Flowable

internal class UserGetByIdsUseCase {

    fun execute(userIds: Set<String>) : Flowable<List<AmityUser>> {
        return UserRepository().getUserByIds(userIds.toList())
            .map {
                it.onEach { user ->
                    UserComposerUseCase().execute(user)
                }
            }
    }

}