package com.amity.socialcloud.sdk.core.data.user

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import org.joda.time.DateTime

internal class UserModelMapper : ModelMapper<UserEntity, AmityUser>() {

    override fun map(entity: UserEntity): AmityUser {
        return AmityUser(
            mid = entity.mid,
            userId = entity.userId,
            displayName = entity.displayName,
            roles = entity.roles,
            flagCount = entity.flagCount,
            metadata = entity.metadata,
            avatarFileId = entity.avatarFileId,
            avatarCustomUrl = entity.avatarCustomUrl,
            description = entity.description ?: "",
            createdAt = entity.createdAt ?: DateTime.now(),
            updatedAt = entity.updatedAt ?: DateTime.now(),
            path = entity.path,
            isGlobalBan = entity.isGlobalBan,
            isDeleted = entity.isDeleted,
            lastHeartbeat = entity.lastHeartbeat
        )
    }
}