package com.amity.socialcloud.sdk.core.data.settings.network

import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateTextsRequest
import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateUrlsRequest
import com.ekoapp.ekosdk.internal.api.dto.ChannelQueryDto
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.socket.request.CreateChannelRequest
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST

interface NetworkSettingsApi {

    @GET("api/v3/network-settings/chat")
    fun getChatSettings(): Single<ChatSettingsDto>

    @POST("api/v3/allowlists/verify")
    fun validateUrls(@Body request: ValidateUrlsRequest): Single<EkoDeletionDto>

    @POST("api/v3/blocklists/verify")
    fun validateTexts(@Body request: ValidateTextsRequest): Single<EkoDeletionDto>

}