package com.amity.socialcloud.sdk.chat.data.channel.paging

import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class MessageReadUsersKeyCreator(
    private val messageId: String,
    private val memberships: List<MessageReadMembershipFilter>,
) : DynamicQueryStreamKeyCreator {
    
    override fun toMap(): Map<String, Any> {
        return mapOf(
            "messageId" to messageId,
            "memberships" to memberships,
        )
    }
    
    override fun getFilterQuery(): String {
        return " true"
    }
}