package com.amity.socialcloud.sdk.chat.data.channel.membership

import com.ekoapp.ekosdk.internal.api.dto.ChannelMembershipQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.*
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import retrofit2.http.*

interface ChannelMembershipApi {

    @GET("api/v4/channels/{channelId}/users")
    fun queryChannelUsers(
        @Path("channelId") channelId: String,
        @Query("search") keyword: String? = null,
        @Query("roles[]") roles: List<String>? = null,
        @Query("memberships[]") memberships: List<String>? = null,
        @Query("sortBy") sortBy: String? = null,
        @Query("options[limit]", encoded = true) limit: Int? = null,
        @Query(value = "options[token]", encoded = true) token: String? = null
    ): Single<ChannelMembershipQueryDto>

    @POST("api/v3/channels/{channelId}/users")
    fun addChannelUsers(
        @Path("channelId") channelId: String,
        @Body request: ChannelAddUsersRequest
    ): Single<ChannelMembershipQueryDto>

    @HTTP(method = "DELETE", path = "api/v3/channels/{channelId}/users", hasBody = true)
    fun deleteChannelUsers(
        @Path("channelId") channelId: String,
        @Body request: ChannelRemoveUsersRequest,
    ): Single<ChannelMembershipQueryDto>

    @POST("api/v3/channels/{channelId}/users/roles")
    fun assignChannelRole(
        @Path("channelId") channelId: String,
        @Body request: ChannelAddRoleRequest
    ): Single<ChannelMembershipQueryDto>

    @HTTP(method = "DELETE", path = "api/v3/channels/{channelId}/users/roles", hasBody = true)
    fun unassignChannelRole(
        @Path("channelId") channelId: String,
        @Body request: ChannelRemoveRoleRequest,
    ): Single<ChannelMembershipQueryDto>

    @PUT("api/v3/channels/{channelId}/users/ban")
    fun banChannelUsers(@Path("channelId") channelId: String, @Body request: ChannelBanUserRequest): Single<ChannelMembershipQueryDto>

    @PUT("api/v3/channels/{channelId}/users/unban")
    fun unbanChannelUsers(@Path("channelId") channelId: String, @Body request: ChannelUnbanUserRequest): Single<ChannelMembershipQueryDto>

    @PUT("api/v2/channel/{channelId}/mute")
    fun muteChannel(
        @Path("channelId") channelId: String,
        @Body request: ChannelSetMutedRequest
    ): Completable

    @PUT("api/v2/channel/{channelId}/users/mute")
    fun muteChannelUser(
        @Path("channelId") channelId: String,
        @Body request: ChannelSetMutedUsersRequest
    ): Completable

}