package com.amity.socialcloud.sdk.chat.domain.channel.member

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipFilter
import com.amity.socialcloud.sdk.api.chat.member.query.AmityChannelMembershipSortOption
import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.chat.domain.channel.member.ChannelMemberComposerUseCase
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetChannelMembershipPagingSourceUseCase {

    fun execute(
        channelId: String,
        filter: AmityChannelMembershipFilter,
        roles: AmityRoles,
        sortOption: AmityChannelMembershipSortOption
    ): Flowable<PagingData<AmityChannelMember>> {
        return ChannelMembershipRepository().getChannelMembershipPagingData(
            channelId = channelId,
            memberships = filter.memberships,
            isMuted = filter.isMuted,
            roles = roles,
            sortOption = sortOption
        ).map { pagingData ->
            pagingData.map(Executors.newSingleThreadExecutor()) { channelMember ->
                ChannelMemberComposerUseCase().execute(channelMember)
            }
        }
    }
}