package com.ekoapp.ekosdk.internal.mapper

import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.core.domain.user.UserComposerUseCase
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowRelationship
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity

internal class EkoUserFollowStatusMapper {

    private fun EkoUserFollowStatusEntity.mapper(): AmityFollowRelationship {
        return AmityFollowRelationship(
            id = id,
            updatedAt = updatedAt,
            sourceUser = getUser(sourceUserId),
            targetUser = getUser(targetUserId),
            status = AmityFollowStatus.enumOf(status)
        )
    }

    private fun getUser(userId: String): AmityUser? {
        return UserRepository().getUser(userId)?.let {
            UserComposerUseCase().execute(it)
        }
    }

    fun map(entity: EkoUserFollowStatusEntity): AmityFollowRelationship {
        return entity.mapper()
    }
}
