package com.ekoapp.ekosdk.internal.keycreator

import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus

class BlockedKeyCreator(
    private val userId: String
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "sourceUserId" to userId
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        return " user_follow.status = '${AmityFollowStatus.BLOCKED.apiKey}'"
    }
}