package com.amity.socialcloud.sdk.chat.data.channel.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.chat.data.channel.ChannelQueryPersister
import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.MarkerSyncEngine
import com.ekoapp.ekosdk.internal.api.dto.ChannelQueryDto
import com.ekoapp.ekosdk.internal.persister.DtoPersister
import io.reactivex.rxjava3.core.Completable

class ChannelQueryDtoPersister : DtoPersister<ChannelQueryDto> {
	
	override fun persistDto(dto: ChannelQueryDto): Completable {
		return dto.channelDtoList
			.filter { MarkerSyncEngine.isMarkerSyncSupport(it.type) }
			.map { it.channelId }
			.let { channelIds ->
				ChannelMarkerRepository().fetchChannelMarker(channelIds)
					.onErrorComplete()
			}
			.andThen(ChannelQueryPersister().persist(dto))
	}
}