package com.amity.socialcloud.sdk.social.data.community.membership.paging

import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembership
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

internal class CommunityMemberSearchKeyCreator(
    private val communityId: String,
    private val roles: AmityRoles,
    private val filters: List<AmityCommunityMembership>?,
    private val sortBy: AmityCommunityMembershipSortOption,
    private val keyword: String?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "communityId" to communityId,
            "roles" to roles,
            "memberships" to (filters ?: listOf()),
            "sortBy" to sortBy,
            "search" to (keyword ?: "")
        )
    }

    override fun getFilterQuery(): String {
        return "community_membership.communityId = '$communityId'"
    }

}