package com.amity.socialcloud.sdk.core.engine.analytics

import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ClickStoryEventCapturer
import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ViewPostEventCapturer
import com.amity.socialcloud.sdk.core.engine.analytics.capturer.ViewStoryEventCapturer
import com.amity.socialcloud.sdk.core.session.component.SessionComponent
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import kotlin.reflect.KClass

internal class AnalyticsEngine(
    sessionLifeCycleEventBus: SessionLifeCycleEventBus,
    sessionStateEventBus: SessionStateEventBus
) : SessionComponent(sessionLifeCycleEventBus, sessionStateEventBus) {

    private val eventCapturers: Map<String, Any> = mapOf(
        ViewPostEventCapturer::class.java.name to ViewPostEventCapturer(),
        ViewStoryEventCapturer::class.java.name to ViewStoryEventCapturer(),
        ClickStoryEventCapturer::class.java.name to ClickStoryEventCapturer(),
    )
    private val eventSyncer = AnalyticsEventSyncer()

    fun <T : Any> getCapturerInstance(clazz: KClass<T>) : T? {
        if (sessionState === SessionState.Established || sessionState === SessionState.TokenExpired) {
            return eventCapturers.get(clazz.java.name)?.let { it as T }
        } else {
            return null
        }
    }

    override fun onSessionStateChange(sessionState: SessionState) {
        // do nothing
    }

    override fun establish(account: EkoAccount) {
        eventSyncer.start()
    }

    override fun destroy() {
        eventSyncer.stop()
        eventSyncer.deleteAllAnalyticsEvents()
    }

    override fun handleTokenExpire() {
        eventSyncer.stop()
    }
}