/*
 * Decompiled with CFR 0.152.
 */
package org.amity.types;

import java.io.Serializable;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.amity.assertions.Assertions;
import org.amity.diagnostics.Logger;
import org.amity.diagnostics.Loggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 62\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u00012\u00020\u0002:\u00016B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eB/\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B\u0011\b\u0016\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017B\u001f\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u0018\u001a\u00020\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0019B\u000f\b\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u0000H\u0096\u0002J\u0013\u0010,\u001a\u00020\u00102\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\b\u0010/\u001a\u00020\u0007H\u0016J\u000e\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u00102\u001a\u00020\u0016J\u0006\u00103\u001a\u00020\u0013J\b\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u00020\u0013H\u0007R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8G\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001e\u00a8\u00067"}, d2={"Lorg/amity/types/ObjectId;", "", "Ljava/io/Serializable;", "date", "Ljava/util/Date;", "(Ljava/util/Date;)V", "counter", "", "(Ljava/util/Date;I)V", "machineIdentifier", "processIdentifier", "", "(Ljava/util/Date;ISI)V", "timestamp", "(IISI)V", "checkCounter", "", "(IISIZ)V", "hexString", "", "(Ljava/lang/String;)V", "bytes", "", "([B)V", "machineAndProcessIdentifier", "(III)V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "getCounter", "()I", "getDate", "()Ljava/util/Date;", "getMachineIdentifier", "getProcessIdentifier", "()S", "time", "", "getTime", "()J", "timeSecond", "getTimeSecond", "compareTo", "other", "equals", "o", "", "hashCode", "putToByteBuffer", "", "toByteArray", "toHexString", "toString", "toStringMongod", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nObjectId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectId.kt\norg/amity/types/ObjectId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,507:1\n1#2:508\n*E\n"})
public final class ObjectId
implements Comparable<ObjectId>,
Serializable {
    @NotNull
    public static final Companion Companion;
    private final int timeSecond;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;
    private static final long serialVersionUID = 3670079982654483072L;
    @NotNull
    private static final Logger LOGGER;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int generatedMachineIdentifier;
    private static final short PROCESS_IDENTIFIER;
    @NotNull
    private static final AtomicInteger NEXT_COUNTER;
    @NotNull
    private static final char[] HEX_CHARS;

    @Deprecated(message="Use #getTimestamp instead")
    public final int getTimeSecond() {
        return this.timeSecond;
    }

    public final int getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public final short getProcessIdentifier() {
        return this.processIdentifier;
    }

    public final int getCounter() {
        return this.counter;
    }

    @JvmOverloads
    public ObjectId(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(ObjectId.Companion.dateToTimestampSeconds(date), generatedMachineIdentifier, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    public /* synthetic */ ObjectId(Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        this(date);
    }

    public ObjectId(@NotNull Date date, int counter) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(date, generatedMachineIdentifier, PROCESS_IDENTIFIER, counter);
    }

    public ObjectId(@NotNull Date date, int machineIdentifier, short processIdentifier, int counter) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this(ObjectId.Companion.dateToTimestampSeconds(date), machineIdentifier, processIdentifier, counter);
    }

    public ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter) {
        this(timestamp, machineIdentifier, processIdentifier, counter, true);
    }

    private ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if (!((machineIdentifier & 0xFF000000) == 0)) {
            boolean $i$a$-require-ObjectId$32 = false;
            String $i$a$-require-ObjectId$32 = "The machine identifier must be between 0 and 16777215 (it must fit in three bytes).";
            throw new IllegalArgumentException($i$a$-require-ObjectId$32.toString());
        }
        if (!(!checkCounter || (counter & 0xFF000000) == 0)) {
            boolean bl = false;
            String string = "The counter must be between 0 and 16777215 (it must fit in three bytes).";
            throw new IllegalArgumentException(string.toString());
        }
        this.timeSecond = timestamp;
        this.machineIdentifier = machineIdentifier;
        this.processIdentifier = processIdentifier;
        this.counter = counter & 0xFFFFFF;
    }

    public ObjectId(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        this(ObjectId.Companion.parseHexString(hexString));
    }

    public ObjectId(@Nullable byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Assertions.notNull("bytes", bytes));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(notNull<ByteArray>(\"bytes\", bytes))");
        this(byteBuffer);
    }

    public ObjectId(int timestamp, int machineAndProcessIdentifier, int counter) {
        this(ObjectId.Companion.legacyToBytes(timestamp, machineAndProcessIdentifier, counter));
    }

    public ObjectId(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        this.timeSecond = ObjectId.Companion.makeInt(buffer.get(), buffer.get(), buffer.get(), buffer.get());
        this.machineIdentifier = ObjectId.Companion.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
        this.processIdentifier = (short)ObjectId.Companion.makeInt((byte)0, (byte)0, buffer.get(), buffer.get());
        this.counter = ObjectId.Companion.makeInt((byte)0, buffer.get(), buffer.get(), buffer.get());
    }

    @NotNull
    public final byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.putToByteBuffer(buffer);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
        return byArray;
    }

    public final void putToByteBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Assertions.notNull("buffer", buffer);
        Assertions.isTrueArgument("buffer.remaining() >=12", buffer.remaining() >= 12);
        buffer.put(ObjectId.Companion.int3(this.timeSecond));
        buffer.put(ObjectId.Companion.int2(this.timeSecond));
        buffer.put(ObjectId.Companion.int1(this.timeSecond));
        buffer.put(ObjectId.Companion.int0(this.timeSecond));
        buffer.put(ObjectId.Companion.int2(this.machineIdentifier));
        buffer.put(ObjectId.Companion.int1(this.machineIdentifier));
        buffer.put(ObjectId.Companion.int0(this.machineIdentifier));
        buffer.put(ObjectId.Companion.short1(this.processIdentifier));
        buffer.put(ObjectId.Companion.short0(this.processIdentifier));
        buffer.put(ObjectId.Companion.int2(this.counter));
        buffer.put(ObjectId.Companion.int1(this.counter));
        buffer.put(ObjectId.Companion.int0(this.counter));
    }

    @NotNull
    public final Date getDate() {
        return new Date((long)this.timeSecond * 1000L);
    }

    @NotNull
    public final String toHexString() {
        char[] chars = new char[24];
        int i = 0;
        for (byte b : this.toByteArray()) {
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
        }
        return new String(chars);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        ObjectId objectId = (ObjectId)o;
        if (this.counter != objectId.counter) {
            return false;
        }
        if (this.machineIdentifier != objectId.machineIdentifier) {
            return false;
        }
        if (this.processIdentifier != objectId.processIdentifier) {
            return false;
        }
        return this.timeSecond == objectId.timeSecond;
    }

    public int hashCode() {
        int result = this.timeSecond;
        result = 31 * result + this.machineIdentifier;
        result = 31 * result + this.processIdentifier;
        result = 31 * result + this.counter;
        return result;
    }

    @Override
    public int compareTo(@Nullable ObjectId other) {
        if (other == null) {
            throw new NullPointerException();
        }
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        for (int i = 0; i < 12; ++i) {
            if (byteArray[i] == otherByteArray[i]) continue;
            return (byteArray[i] & 0xFF) < (otherByteArray[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return this.toHexString();
    }

    @Deprecated(message="Use #getDate instead")
    public final long getTime() {
        return (long)this.timeSecond * 1000L;
    }

    @Deprecated(message="use {@link #toHexString()}")
    @NotNull
    public final String toStringMongod() {
        return this.toHexString();
    }

    @JvmOverloads
    public ObjectId() {
        this(null, 1, null);
    }

    static {
        int n;
        Companion = new Companion(null);
        LOGGER = Loggers.getLogger("ObjectId");
        try {
            n = ObjectId.Companion.createMachineIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        generatedMachineIdentifier = n;
        try {
            n = ObjectId.Companion.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        PROCESS_IDENTIFIER = (short)n;
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_CHARS = cArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nJ\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0019J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J(\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020#H\u0002J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020+H\u0002J\u0010\u00108\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u00109\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/amity/types/ObjectId$Companion;", "", "()V", "HEX_CHARS", "", "LOGGER", "Lorg/amity/diagnostics/Logger;", "getLOGGER", "()Lorg/amity/diagnostics/Logger;", "LOW_ORDER_THREE_BYTES", "", "NEXT_COUNTER", "Ljava/util/concurrent/atomic/AtomicInteger;", "PROCESS_IDENTIFIER", "", "currentCounter", "getCurrentCounter", "()I", "generatedMachineIdentifier", "getGeneratedMachineIdentifier", "generatedProcessIdentifier", "getGeneratedProcessIdentifier", "serialVersionUID", "", "createFromLegacyFormat", "Lorg/amity/types/ObjectId;", "time", "machine", "inc", "createMachineIdentifier", "createProcessIdentifier", "dateToTimestampSeconds", "Ljava/util/Date;", "get", "int0", "", "x", "int1", "int2", "int3", "isValid", "", "hexString", "", "legacyToBytes", "", "timestamp", "machineAndProcessIdentifier", "counter", "makeInt", "b3", "b2", "b1", "b0", "parseHexString", "s", "short0", "short1", "amity-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nObjectId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectId.kt\norg/amity/types/ObjectId$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,507:1\n1#2:508\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final int getGeneratedMachineIdentifier() {
            return generatedMachineIdentifier;
        }

        @NotNull
        public final ObjectId get() {
            return new ObjectId(null, 1, null);
        }

        public final boolean isValid(@Nullable String hexString) {
            if (hexString == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            int len = hexString.length();
            if (len != 24) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c = hexString.charAt(i);
                if ('0' <= c ? c < ':' : false) continue;
                if ('a' <= c ? c < 'g' : false) continue;
                if ('A' <= c ? c < 'G' : false) continue;
                return false;
            }
            return true;
        }

        public final int getGeneratedProcessIdentifier() {
            return PROCESS_IDENTIFIER;
        }

        public final int getCurrentCounter() {
            return NEXT_COUNTER.get();
        }

        @NotNull
        public final ObjectId createFromLegacyFormat(int time, int machine, int inc) {
            return new ObjectId(time, machine, inc);
        }

        private final byte[] legacyToBytes(int timestamp, int machineAndProcessIdentifier, int counter) {
            byte[] bytes = new byte[]{this.int3(timestamp), this.int2(timestamp), this.int1(timestamp), this.int0(timestamp), this.int3(machineAndProcessIdentifier), this.int2(machineAndProcessIdentifier), this.int1(machineAndProcessIdentifier), this.int0(machineAndProcessIdentifier), this.int3(counter), this.int2(counter), this.int1(counter), this.int0(counter)};
            return bytes;
        }

        private final int createMachineIdentifier() {
            int machinePiece = 0;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                    byte[] mac = ni.getHardwareAddress();
                    if (mac == null) continue;
                    ByteBuffer bb = ByteBuffer.wrap(mac);
                    try {
                        sb.append(bb.getChar());
                        sb.append(bb.getChar());
                        sb.append(bb.getChar());
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {}
                }
                machinePiece = sb.toString().hashCode();
            }
            catch (Throwable t) {
                machinePiece = new SecureRandom().nextInt();
                this.getLOGGER().warn("Failed to get machine identifier from network interface, using random number instead", t);
            }
            return machinePiece &= 0xFFFFFF;
        }

        private final short createProcessIdentifier() {
            return (short)new SecureRandom().nextInt();
        }

        private final byte[] parseHexString(String s) {
            if (!this.isValid(s)) {
                boolean $i$a$-require-ObjectId$Companion$parseHexString$22 = false;
                String $i$a$-require-ObjectId$Companion$parseHexString$22 = "invalid hexadecimal representation of an ObjectId: [" + s + ']';
                throw new IllegalArgumentException($i$a$-require-ObjectId$Companion$parseHexString$22.toString());
            }
            byte[] b = new byte[12];
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                String string = s.substring(i * 2, i * 2 + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                b[i] = (byte)Integer.parseInt(string, CharsKt.checkRadix((int)16));
            }
            return b;
        }

        private final int dateToTimestampSeconds(Date time) {
            return (int)(time.getTime() / (long)1000);
        }

        private final int makeInt(byte b3, byte b2, byte b1, byte b0) {
            return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
        }

        private final byte int3(int x) {
            return (byte)(x >> 24);
        }

        private final byte int2(int x) {
            return (byte)(x >> 16);
        }

        private final byte int1(int x) {
            return (byte)(x >> 8);
        }

        private final byte int0(int x) {
            return (byte)x;
        }

        private final byte short1(short x) {
            return (byte)(x >> 8);
        }

        private final byte short0(short x) {
            return (byte)x;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

