/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.stream;

import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamSessionEntity;
import com.amity.socialcloud.sdk.video.data.stream.StreamSessionSyncState;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamSessionDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0005\u001a\u00020\u0006J%\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0018\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0019\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000f\u00a8\u0006\u001d"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/stream/StreamSessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "createStreamSession", "", "sessionId", "", "streamId", "title", "startedAt", "Lorg/joda/time/DateTime;", "resolution", "deleteIfExceedRetry", "streamEntities", "", "Lcom/amity/socialcloud/sdk/entity/video/stream/EkoStreamSessionEntity;", "getById", "Lio/reactivex/rxjava3/core/Flowable;", "getStreamSessionCollection", "syncStateArray", "", "Lcom/amity/socialcloud/sdk/video/data/stream/StreamSessionSyncState;", "([Lcom/amity/socialcloud/sdk/video/data/stream/StreamSessionSyncState;)Lio/reactivex/rxjava3/core/Flowable;", "markAsFailed", "markAsSynced", "markAsSyncing", "resetSyncState", "updateStreamSession", "streamEntity", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nStreamSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamSessionRepository.kt\ncom/ekoapp/ekosdk/internal/repository/stream/StreamSessionRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n13579#2,2:79\n37#3,2:81\n1855#4,2:83\n1855#4,2:85\n1855#4,2:87\n1855#4,2:89\n*S KotlinDebug\n*F\n+ 1 StreamSessionRepository.kt\ncom/ekoapp/ekosdk/internal/repository/stream/StreamSessionRepository\n*L\n15#1:79,2\n16#1:81,2\n48#1:83,2\n54#1:85,2\n60#1:87,2\n70#1:89,2\n*E\n"})
public final class StreamSessionRepository
extends EkoObjectRepository {
    @NotNull
    public final Flowable<List<EkoStreamSessionEntity>> getStreamSessionCollection(@NotNull StreamSessionSyncState[] syncStateArray) {
        Intrinsics.checkNotNullParameter((Object)syncStateArray, (String)"syncStateArray");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        ArrayList<String> syncStateList = new ArrayList<String>();
        StreamSessionSyncState[] $this$forEach$iv = syncStateArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            StreamSessionSyncState element$iv;
            StreamSessionSyncState it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            syncStateList.add(it.getKey());
        }
        Collection $this$toTypedArray$iv = syncStateList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return streamDao.getAll(thisCollection$iv.toArray(new String[0]));
    }

    @NotNull
    public final Flowable<EkoStreamSessionEntity> getById(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        return streamDao.getById(sessionId);
    }

    public final void resetSyncState() {
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        streamDao.updateSyncState(StreamSessionSyncState.SYNCING, StreamSessionSyncState.PENDING);
    }

    public final void createStreamSession(@NotNull String sessionId, @NotNull String streamId, @NotNull String title, @NotNull DateTime startedAt, @NotNull String resolution) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        EkoStreamSessionEntity streamSession = new EkoStreamSessionEntity();
        streamSession.setSessionId(sessionId);
        streamSession.setStreamId(streamId);
        streamSession.setTitle(title);
        streamSession.setStartTime(startedAt);
        streamSession.setResolution(resolution);
        streamDao.insert((EkoObject)streamSession);
    }

    public final void updateStreamSession(@NotNull EkoStreamSessionEntity streamEntity) {
        Intrinsics.checkNotNullParameter((Object)streamEntity, (String)"streamEntity");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        streamDao.update((EkoObject)streamEntity);
    }

    public final void markAsSyncing(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkNotNullParameter(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.SYNCING.getKey());
        }
        streamDao.update(streamEntities);
    }

    public final void markAsSynced(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkNotNullParameter(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.SYNCED.getKey());
        }
        streamDao.update(streamEntities);
    }

    public final void markAsFailed(@NotNull List<EkoStreamSessionEntity> streamEntities) {
        Intrinsics.checkNotNullParameter(streamEntities, (String)"streamEntities");
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(StreamSessionSyncState.PENDING.getKey());
            int n = it.getRetryCount();
            it.setRetryCount(n + 1);
        }
        streamDao.update(streamEntities);
        this.deleteIfExceedRetry(streamEntities);
    }

    private final void deleteIfExceedRetry(List<EkoStreamSessionEntity> streamEntities) {
        EkoStreamSessionDao streamDao = UserDatabase.get().streamSessionDao();
        Iterable $this$forEach$iv = streamEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoStreamSessionEntity it = (EkoStreamSessionEntity)element$iv;
            boolean bl = false;
            if (it.getRetryCount() <= 3) continue;
            streamDao.delete((EkoObject)it);
        }
    }
}

