/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;

@Entity(tableName="mqtt_url")
public class EkoMqttUrl {
    private static final String SINGLETON_MQTT_URL_ID = "SINGLETON_MQTT_URL_ID";
    @PrimaryKey
    @NonNull
    private String id = EkoMqttUrl.currentMqttUrlId();
    private String mqttUrl;
    private long updateAt = System.currentTimeMillis();

    public static String currentMqttUrlId() {
        return SINGLETON_MQTT_URL_ID;
    }

    @NonNull
    public String getId() {
        return EkoMqttUrl.currentMqttUrlId();
    }

    public void setId(String id) {
        this.id = EkoMqttUrl.currentMqttUrlId();
    }

    @NonNull
    public String getMqttUrl() {
        return this.mqttUrl;
    }

    public void setMqttUrl(@NonNull String httpUrl) {
        this.mqttUrl = EkoPreconditions.checkValidId(httpUrl, "mqttUrl");
    }

    public long getUpdateAt() {
        return this.updateAt;
    }

    public void setUpdateAt(long updateAt) {
        this.updateAt = updateAt;
    }

    public static EkoMqttUrl create(@NonNull String url) {
        EkoMqttUrl urlStore = new EkoMqttUrl();
        urlStore.setMqttUrl(url);
        return urlStore;
    }
}

