/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.story;

import com.amity.socialcloud.sdk.common.QueryPersister;
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper;
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore;
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper;
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore;
import com.amity.socialcloud.sdk.dto.social.story.StoryDto;
import com.amity.socialcloud.sdk.dto.social.story.StoryQueryDto;
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.data.category.CategoryEntityMapper;
import com.amity.socialcloud.sdk.social.data.category.CategoryLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.CommunityEntityMapper;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper;
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore;
import com.amity.socialcloud.sdk.social.data.story.StoryEntityMapper;
import com.amity.socialcloud.sdk.social.data.story.StoryLocalDataStore;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetEntityMapper;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetLocalDataStore;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/social/data/story/StoryQueryPersister;", "Lcom/amity/socialcloud/sdk/common/QueryPersister;", "Lcom/amity/socialcloud/sdk/dto/social/story/StoryQueryDto;", "()V", "createMissingTargets", "", "Lcom/amity/socialcloud/sdk/entity/social/story/StoryTargetEntity;", "stories", "Lcom/amity/socialcloud/sdk/dto/social/story/StoryDto;", "persist", "Lio/reactivex/rxjava3/core/Completable;", "dto", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nStoryQueryPersister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoryQueryPersister.kt\ncom/amity/socialcloud/sdk/social/data/story/StoryQueryPersister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 StoryQueryPersister.kt\ncom/amity/socialcloud/sdk/social/data/story/StoryQueryPersister\n*L\n84#1:115,2\n*E\n"})
public final class StoryQueryPersister
extends QueryPersister<StoryQueryDto> {
    @Override
    @NotNull
    public Completable persist(@NotNull StoryQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        FileLocalDataStore fileLocalDataStore = new FileLocalDataStore();
        FileEntityMapper fileEntityMapper = new FileEntityMapper();
        List list2 = dto.getFiles();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Completable completable = fileLocalDataStore.saveFiles(fileEntityMapper.map(list2));
        UserLocalDataStore userLocalDataStore = new UserLocalDataStore();
        UserEntityMapper userEntityMapper = new UserEntityMapper();
        List list3 = dto.getUsers();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Completable completable2 = completable.andThen((CompletableSource)userLocalDataStore.saveUsers(userEntityMapper.map(list3)));
        UserFlagLocalDataStore userFlagLocalDataStore = new UserFlagLocalDataStore();
        UserFlagEntityMapper userFlagEntityMapper = new UserFlagEntityMapper();
        List list4 = dto.getUsers();
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        Completable completable3 = completable2.andThen((CompletableSource)userFlagLocalDataStore.saveFlags(userFlagEntityMapper.map(list4)));
        CategoryLocalDataStore categoryLocalDataStore = new CategoryLocalDataStore();
        CategoryEntityMapper categoryEntityMapper = new CategoryEntityMapper();
        List list5 = dto.getCommunityCategories();
        if (list5 == null) {
            list5 = CollectionsKt.emptyList();
        }
        Completable completable4 = completable3.andThen((CompletableSource)categoryLocalDataStore.saveCategories(categoryEntityMapper.map(list5)));
        CommunityMembershipLocalDataStore communityMembershipLocalDataStore = new CommunityMembershipLocalDataStore();
        CommunityMembershipEntityMapper communityMembershipEntityMapper = new CommunityMembershipEntityMapper();
        List list6 = dto.getCommunityUsers();
        if (list6 == null) {
            list6 = CollectionsKt.emptyList();
        }
        Completable completable5 = completable4.andThen((CompletableSource)communityMembershipLocalDataStore.saveMemberships(communityMembershipEntityMapper.map(list6)));
        CommunityLocalDataStore communityLocalDataStore = new CommunityLocalDataStore();
        CommunityEntityMapper communityEntityMapper = new CommunityEntityMapper();
        List list7 = dto.getCommunities();
        if (list7 == null) {
            list7 = CollectionsKt.emptyList();
        }
        Completable completable6 = completable5.andThen((CompletableSource)communityLocalDataStore.saveCommunities(communityEntityMapper.map(list7)));
        StoryTargetLocalDataStore storyTargetLocalDataStore = new StoryTargetLocalDataStore();
        StoryTargetEntityMapper storyTargetEntityMapper = new StoryTargetEntityMapper();
        List list8 = dto.getStoryTargets();
        if (list8 == null) {
            list8 = CollectionsKt.emptyList();
        }
        Completable completable7 = completable6.andThen((CompletableSource)storyTargetLocalDataStore.saveStoryTarget(storyTargetEntityMapper.map(list8)));
        StoryLocalDataStore storyLocalDataStore = new StoryLocalDataStore();
        StoryEntityMapper storyEntityMapper = new StoryEntityMapper();
        List list9 = dto.getStories();
        if (list9 == null) {
            list9 = CollectionsKt.emptyList();
        }
        Completable completable8 = completable7.andThen((CompletableSource)storyLocalDataStore.saveStories(storyEntityMapper.map(list9)));
        Intrinsics.checkNotNullExpressionValue((Object)completable8, (String)"FileLocalDataStore().sav\u2026          )\n            )");
        return completable8;
    }

    private final List<StoryTargetEntity> createMissingTargets(List<StoryDto> stories) {
        Map missingTargets = new LinkedHashMap();
        Iterable $this$forEach$iv = stories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            StoryTargetEntity storyTargetEntity;
            AmityStoryTarget cacheTarget;
            StoryDto it = (StoryDto)element$iv;
            boolean bl = false;
            StoryTargetRepository storyTargetRepository = new StoryTargetRepository();
            AmityStory.TargetType targetType = AmityStory.TargetType.Companion.enumOf(it.getTargetType());
            String string2 = it.getTargetId();
            if (string2 == null) {
                string2 = "";
            }
            if ((cacheTarget = storyTargetRepository.getStoryTarget(targetType, string2)) != null) continue;
            StoryTargetEntity $this$createMissingTargets_u24lambda_u241_u24lambda_u240 = storyTargetEntity = new StoryTargetEntity();
            boolean bl2 = false;
            String string3 = it.getTargetType();
            if (string3 == null) {
                string3 = "unknown";
            }
            if ((string = it.getTargetId()) == null) {
                string = "";
            }
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setUniqueId(AmityStoryTarget.Companion.generateUniqueId$amity_sdk_release(string3, string));
            String string4 = it.getTargetType();
            if (string4 == null) {
                string4 = "unknown";
            }
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setTargetType(string4);
            String string5 = it.getTargetId();
            if (string5 == null) {
                string5 = "";
            }
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setTargetId(string5);
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setLastStoryExpiresAt(it.getExpiresAt());
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setLastStorySeenExpiresAt(null);
            $this$createMissingTargets_u24lambda_u241_u24lambda_u240.setUpdatedAt(it.getExpiresAt());
            StoryTargetEntity target = storyTargetEntity;
            StoryTargetEntity duplicateTarget = (StoryTargetEntity)missingTargets.get(target.getUniqueId());
            if (duplicateTarget != null) {
                DateTime dateTime = target.getLastStoryExpiresAt();
                boolean bl3 = dateTime != null ? dateTime.isAfter((ReadableInstant)target.getLastStoryExpiresAt()) : false;
                if (!bl3) continue;
                missingTargets.put(target.getUniqueId(), target);
                continue;
            }
            missingTargets.put(target.getUniqueId(), target);
        }
        return CollectionsKt.toList((Iterable)missingTargets.values());
    }
}

