/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ReCalculateChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.subchannel.OptimisticCreateSubChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.sync.SyncMarkerUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.user.GetUserMarkerUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkerEvent;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEvent;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkerDto;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkersDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0016H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0002J\u0006\u0010'\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020\u0016J\u0006\u0010)\u001a\u00020\u0016J\b\u0010*\u001a\u00020\u0013H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "deviceLastSyncAt", "Lorg/joda/time/DateTime;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "events", "", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEvent;", "isConsistentMode", "", "isReadyToSync", "isWaitingForResponse", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "addNewEvent", "", "event", "destroy", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "fetchDeviceLastSyncAt", "Lio/reactivex/rxjava3/core/Single;", "getDeviceLastSyncAt", "handleConsistentEvent", "Lcom/amity/socialcloud/sdk/core/MarkerEvent;", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "saveDeviceLastSyncAt", "lastSyncAt", "startMarkerSync", "startUserTotalUnreadSync", "stopMarkerSync", "timerDidTrigger", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMarkerSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public final class MarkerSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Completable timer;
    private boolean isWaitingForResponse;
    @NotNull
    private final List<MarkerSyncEvent> events;
    @Nullable
    private DateTime deviceLastSyncAt;
    private boolean isReadyToSync;
    private boolean isConsistentMode;
    @NotNull
    private final CompositeDisposable disposable;
    private static final long SYNC_INTERVAL = 2L;
    @NotNull
    private static final List<AmityChannel.Type> SUPPORT_CHANNEL_TYPES;

    public MarkerSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        Completable completable = Flowable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ MarkerSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(long it) {
                return (CompletableSource)MarkerSyncEngine.access$timerDidTrigger(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"interval(SYNC_INTERVAL,T\u2026scribeOn(Schedulers.io())");
        this.timer = completable;
        this.events = new ArrayList();
        this.isConsistentMode = true;
        this.disposable = new CompositeDisposable();
        MarkerEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(@NotNull MarkerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MarkerEvent markerEvent = event;
                if (markerEvent instanceof MarkerEvent.NetworkConnection.Connected) {
                    this.addNewEvent(MarkerSyncEvent.RESUME);
                } else if (markerEvent instanceof MarkerEvent.NetworkConnection.Disconnected) {
                    isWaitingForResponse = false;
                } else if (markerEvent instanceof MarkerEvent.NewMessage) {
                    String string = ((MarkerEvent.NewMessage)event).getMessage().getChannelType();
                    Companion companion = Companion;
                    String p0 = string;
                    boolean bl = false;
                    if (companion.isMarkerSyncSupport(p0)) {
                        this.addNewEvent(MarkerSyncEvent.NEW_MESSAGE);
                        this.handleConsistentEvent(event);
                    }
                } else if (markerEvent instanceof MarkerEvent.MarkerUpdated) {
                    this.addNewEvent(MarkerSyncEvent.MARKER_UPDATED);
                    this.handleConsistentEvent(event);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe();
    }

    public final boolean isConsistentMode() {
        return this.isConsistentMode;
    }

    public final void startMarkerSync() {
        CoreClient.INSTANCE.enableUnreadCount();
        this.isConsistentMode = false;
        this.addNewEvent(MarkerSyncEvent.START_SYNCING);
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    public final void startUserTotalUnreadSync() {
        this.addNewEvent(MarkerSyncEvent.START_SYNCING);
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    public final void stopMarkerSync() {
        if (this.disposable.size() > 0) {
            this.disposable.clear();
            this.events.clear();
        }
        this.isWaitingForResponse = false;
    }

    private final Completable timerDidTrigger() {
        Completable completable;
        if (this.isWaitingForResponse) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete()");
        } else if (this.events.isEmpty()) {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"complete()");
        } else if (!this.isReadyToSync) {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"complete()");
        } else {
            this.events.clear();
            this.isWaitingForResponse = true;
            Completable completable5 = this.fetchDeviceLastSyncAt().flatMap(new Function(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public final SingleSource<? extends Pair<List<UserMarkerDto>, Boolean>> apply(boolean it) {
                    return (SingleSource)new SyncMarkerUseCase().execute(MarkerSyncEngine.access$getDeviceLastSyncAt(this.this$0));
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull Pair<? extends List<UserMarkerDto>, Boolean> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    List userMarkers = (List)pair.component1();
                    boolean hasMoreMarkers = (Boolean)pair.component2();
                    UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull((List)userMarkers);
                    if (userMarkerDto != null && (userMarkerDto = userMarkerDto.getLastSyncAt()) != null) {
                        UserMarkerDto userMarkerDto2 = userMarkerDto;
                        MarkerSyncEngine markerSyncEngine = this.this$0;
                        UserMarkerDto p0 = userMarkerDto2;
                        boolean bl = false;
                        MarkerSyncEngine.access$saveDeviceLastSyncAt(markerSyncEngine, (DateTime)p0);
                    }
                    if (hasMoreMarkers) {
                        MarkerSyncEngine.access$addNewEvent(this.this$0, MarkerSyncEvent.HAS_MORE);
                    }
                }
            }).doFinally(() -> MarkerSyncEngine.timerDidTrigger$lambda$1(this)).ignoreElement().subscribeOn(Schedulers.io());
            completable = completable5;
            Intrinsics.checkNotNullExpressionValue((Object)completable5, (String)"private fun timerDidTrig\u2026edulers.io())\n\t\t\t}\n\t\t}\n\t}");
        }
        return completable;
    }

    private final void addNewEvent(MarkerSyncEvent event) {
        this.events.add(event);
    }

    private final Single<Boolean> fetchDeviceLastSyncAt() {
        Single single;
        if (this.deviceLastSyncAt == null) {
            Single single2 = new GetUserMarkerUseCase().execute().doOnSuccess(new Consumer(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(@NotNull UserMarkersDto userMarkers) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)userMarkers, (String)"userMarkers");
                        UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull(userMarkers.getUserMarkers());
                        if (userMarkerDto == null) break block0;
                        UserMarkerDto userMarkerDto2 = userMarkerDto;
                        MarkerSyncEngine markerSyncEngine = this.this$0;
                        UserMarkerDto userMarker = userMarkerDto2;
                        boolean bl = false;
                        MarkerSyncEngine.access$saveDeviceLastSyncAt(markerSyncEngine, userMarker.getLastSyncAt());
                    }
                }
            }).map((Function)fetchDeviceLastSyncAt.2.INSTANCE).onErrorReturnItem((Object)true);
            single = single2;
            Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"private fun fetchDeviceL\u2026\tSingle.just(true)\n\t\t}\n\t}");
        } else {
            Single single3 = Single.just((Object)true);
            single = single3;
            Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n\t\t\tSingle.just(true)\n\t\t}");
        }
        return single;
    }

    private final DateTime getDeviceLastSyncAt() {
        return this.deviceLastSyncAt;
    }

    private final void saveDeviceLastSyncAt(DateTime lastSyncAt) {
        block4: {
            block3: {
                if (this.deviceLastSyncAt == null) break block3;
                DateTime dateTime = this.deviceLastSyncAt;
                boolean bl = dateTime != null ? dateTime.isBefore((ReadableInstant)lastSyncAt) : false;
                if (!bl) break block4;
            }
            this.deviceLastSyncAt = lastSyncAt;
        }
    }

    private final void handleConsistentEvent(MarkerEvent event) {
        MarkerEvent markerEvent = event;
        if (markerEvent instanceof MarkerEvent.SubChannelCreated) {
            String channelId;
            SubChannelDto subChannel;
            SubChannelDto subChannelDto = subChannel = (SubChannelDto)CollectionsKt.firstOrNull(((MarkerEvent.SubChannelCreated)event).getDto().getSubChannels());
            String subChannelId = subChannelDto != null ? subChannelDto.getSubChannelId() : null;
            SubChannelDto subChannelDto2 = subChannel;
            String string = channelId = subChannelDto2 != null ? subChannelDto2.getChannelId() : null;
            if (subChannelId != null && channelId != null) {
                new OptimisticCreateSubChannelUnreadInfoUseCase().execute(subChannelId, channelId);
            }
        } else if (markerEvent instanceof MarkerEvent.SubChannelDeleted) {
            SubChannelDto subChannelDto = (SubChannelDto)CollectionsKt.firstOrNull(((MarkerEvent.SubChannelDeleted)event).getDto().getSubChannels());
            if (subChannelDto != null) {
                String it;
                SubChannelDto subChannel = subChannelDto;
                boolean bl = false;
                String string = subChannel.getSubChannelId();
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    new SubChannelMarkerRepository().deleteUnreadInfoBySubChannelId(it);
                }
                String string2 = subChannel.getChannelId();
                if (string2 != null) {
                    it = string2;
                    boolean bl3 = false;
                    new ReCalculateChannelUnreadInfoUseCase().execute(it);
                    new ChannelRepository().notifyChanges$amity_sdk_release(it);
                }
            }
        } else if ((markerEvent instanceof MarkerEvent.ChannelLeft ? true : markerEvent instanceof MarkerEvent.ChannelDeleted) ? true : markerEvent instanceof MarkerEvent.ChannelBan) {
            Object object = event instanceof MarkerEvent.Channel ? (MarkerEvent.Channel)event : null;
            if (object != null && (object = ((MarkerEvent.Channel)object).getDto()) != null && (object = ((ChannelEventDto)object).getChannelDtoList()) != null && (object = (EkoChannelDto)CollectionsKt.firstOrNull(object)) != null && (object = ((EkoChannelDto)object).getChannelId()) != null) {
                Object it = object;
                boolean bl = false;
                new SubChannelMarkerRepository().deleteUnreadInfoByChannelId((String)it);
            }
        } else if (markerEvent instanceof MarkerEvent.NewMessage) {
            String subChannelId = ((MarkerEvent.NewMessage)event).getMessage().getSubChannelId();
            String channelId = ((MarkerEvent.NewMessage)event).getMessage().getChannelId();
            SubChannelMarkerRepository subChannelMarkerRepository = new SubChannelMarkerRepository();
            Intrinsics.checkNotNullExpressionValue((Object)subChannelId, (String)"subChannelId");
            SubChannelUnreadInfoEntity subChannelUnreadInfo = subChannelMarkerRepository.getSubChannelUnreadInfo(subChannelId);
            if (subChannelUnreadInfo != null && ((MarkerEvent.NewMessage)event).getMessage().getSegment() > subChannelUnreadInfo.getLastSegment()) {
                subChannelUnreadInfo.setLastSegment(((MarkerEvent.NewMessage)event).getMessage().getSegment());
                subChannelUnreadInfo.setUpdatedAt(DateTime.now());
                new SubChannelMarkerRepository().saveSubChannelUnreadInfo(CollectionsKt.listOf((Object)subChannelUnreadInfo));
                new SubChannelRepository().notifyChanges$amity_sdk_release(subChannelId);
                ChannelRepository channelRepository = new ChannelRepository();
                Intrinsics.checkNotNullExpressionValue((Object)channelId, (String)"channelId");
                channelRepository.notifyChanges$amity_sdk_release(channelId);
            }
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        this.isReadyToSync = Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToSync = true;
        if (CoreClient.INSTANCE.isUnreadCountEnable() && this.isConsistentMode) {
            this.startUserTotalUnreadSync();
        }
    }

    @Override
    public void destroy() {
        this.stopMarkerSync();
        this.isReadyToSync = false;
        this.deviceLastSyncAt = null;
    }

    @Override
    public void handleTokenExpire() {
        this.stopMarkerSync();
        this.isReadyToSync = false;
    }

    private static final void timerDidTrigger$lambda$1(MarkerSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isWaitingForResponse = false;
    }

    public static final /* synthetic */ DateTime access$getDeviceLastSyncAt(MarkerSyncEngine $this) {
        return $this.getDeviceLastSyncAt();
    }

    public static final /* synthetic */ void access$saveDeviceLastSyncAt(MarkerSyncEngine $this, DateTime lastSyncAt) {
        $this.saveDeviceLastSyncAt(lastSyncAt);
    }

    public static final /* synthetic */ Completable access$timerDidTrigger(MarkerSyncEngine $this) {
        return $this.timerDidTrigger();
    }

    static {
        AmityChannel.Type[] typeArray = new AmityChannel.Type[]{AmityChannel.Type.COMMUNITY, AmityChannel.Type.CONVERSATION, AmityChannel.Type.BROADCAST};
        SUPPORT_CHANNEL_TYPES = CollectionsKt.listOf((Object[])typeArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion;", "", "()V", "SUPPORT_CHANNEL_TYPES", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "SYNC_INTERVAL", "", "isMarkerSyncSupport", "", "type", "", "amity-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nMarkerSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1#2:244\n1549#3:245\n1620#3,3:246\n*S KotlinDebug\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion\n*L\n212#1:245\n212#1:246,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMarkerSyncSupport(@Nullable AmityChannel.Type type) {
            boolean bl;
            AmityChannel.Type type2 = type;
            if (type2 != null) {
                AmityChannel.Type type3 = type2;
                List list2 = SUPPORT_CHANNEL_TYPES;
                AmityChannel.Type p0 = type3;
                boolean bl2 = false;
                bl = list2.contains((Object)p0);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isMarkerSyncSupport(@Nullable String type) {
            boolean bl;
            String string = type;
            if (string != null) {
                void $this$mapTo$iv$iv;
                String string2 = string;
                Iterable $this$map$iv = SUPPORT_CHANNEL_TYPES;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AmityChannel.Type type2 = (AmityChannel.Type)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getApiKey());
                }
                List list2 = (List)destination$iv$iv;
                String p0 = string2;
                boolean bl3 = false;
                bl = list2.contains(p0);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

