/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.usecase.analytics;

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsService;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget;
import com.amity.socialcloud.sdk.social.data.story.StoryRepository;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ekoapp/ekosdk/internal/usecase/analytics/MarkStoryAsViewedUseCase;", "", "()V", "execute", "", "storyId", "", "amity-sdk_release"})
public final class MarkStoryAsViewedUseCase {
    public final void execute(@NotNull String storyId) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
            if (StringsKt.startsWith$default((String)storyId, (String)"LOCAL_", (boolean)false, (int)2, null)) {
                return;
            }
            new AnalyticsService().markStoryAsViewed(storyId);
            AmityStory amityStory = new StoryRepository().getStoryNow(storyId);
            if (amityStory == null) break block6;
            AmityStory it = amityStory;
            boolean bl = false;
            AmityStoryTarget storyTarget = new StoryTargetRepository().getStoryTarget(it.getTargetType(), it.getTargetId());
            if (storyTarget != null) {
                boolean bl2;
                DateTime dateTime = it.getExpiresAt();
                if (dateTime != null) {
                    DateTime dateTime2 = storyTarget.getLastStorySeenExpiresAt();
                    if (dateTime2 == null) {
                        dateTime2 = DateTime.now();
                    }
                    bl2 = dateTime.isAfter((ReadableInstant)dateTime2);
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    new StoryTargetRepository().updateStoryTargetLastStorySeenExpiresAt(it.getTargetType(), it.getTargetId(), it.getExpiresAt()).andThen((CompletableSource)new StoryRepository().triggerStoryReload(storyId)).onErrorComplete().subscribeOn(Schedulers.io()).subscribe();
                }
            }
        }
    }
}

