/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.domain.comment;

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.domain.comment.LatestRepliesGetUseCase;
import com.amity.socialcloud.sdk.social.domain.comment.flag.IsCommentFlaggedByMeUseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/amity/socialcloud/sdk/social/domain/comment/CommentComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "()V", "addCommentUser", "", "comment", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "addLatestReplies", "addMentioneeUser", "addMyFlag", "addMyReactions", "execute", "amity-sdk_release"})
public final class CommentComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityComment execute(@NotNull AmityComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.addLatestReplies(comment);
        this.addMyReactions(comment);
        this.addMyFlag(comment);
        this.addCommentUser(comment);
        this.addMentioneeUser(comment);
        return comment;
    }

    private final void addMyReactions(AmityComment comment) {
        comment.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.COMMENT, comment.getCommentId()));
    }

    private final void addMyFlag(AmityComment comment) {
        comment.setFlaggedByMe$amity_sdk_release(new IsCommentFlaggedByMeUseCase().execute(comment.getCommentId()));
    }

    private final void addCommentUser(AmityComment comment) {
        comment.setUser$amity_sdk_release(new UserGetUseCase().execute(comment.getCreatorId()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMentioneeUser(AmityComment comment) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = comment.getMentionees();
        AmityComment amityComment = comment;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityMentionee amityMentionee = (AmityMentionee)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof AmityMentionee.USER) {
                ((AmityMentionee.USER)it).setUser$amity_sdk_release(new UserGetUseCase().execute(((AmityMentionee.USER)it).getUserId()));
            }
            void var13_13 = it;
            collection.add(var13_13);
        }
        collection = (List)destination$iv$iv;
        amityComment.setMentionees$amity_sdk_release((List<? extends AmityMentionee>)collection);
    }

    private final void addLatestReplies(AmityComment comment) {
        comment.setLatestReplies$amity_sdk_release(new LatestRepliesGetUseCase().execute(comment.getReferenceType$amity_sdk_release(), comment.getReferenceId$amity_sdk_release(), comment.getCommentId()));
    }
}

