/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.model.core.error;

import com.amity.socialcloud.sdk.model.core.error.AmityError;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.HttpException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 \f2\u00060\u0001j\u0002`\u0002:\u0001\fB#\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "code", "", "(Ljava/lang/String;Ljava/lang/Throwable;I)V", "getCode", "()I", "Companion", "amity-sdk_release"})
public class AmityException
extends Exception {
    private final int code;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getCode() {
        return this.code;
    }

    protected AmityException(@Nullable String message, @Nullable Throwable cause, int code) {
        super(message, cause);
        this.code = code;
    }

    @JvmStatic
    @NotNull
    public static final AmityException create(@Nullable String message, @Nullable Throwable cause, int code) {
        return Companion.create(message, cause, code);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/model/core/error/AmityException$Companion;", "", "()V", "create", "Lcom/amity/socialcloud/sdk/model/core/error/AmityException;", "message", "", "cause", "", "error", "Lcom/amity/socialcloud/sdk/model/core/error/AmityError;", "code", "", "fromResponse", "response", "Lokhttp3/Response;", "fromThrowable", "throwable", "amity-sdk_release"})
    public static final class Companion {
        @NotNull
        public final AmityException create(@Nullable String message, @Nullable Throwable cause, @NotNull AmityError error) {
            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            return this.create(message, cause, error.getCode());
        }

        @JvmStatic
        @NotNull
        public final AmityException create(@Nullable String message, @Nullable Throwable cause, int code) {
            return new AmityException(message, cause, code);
        }

        @NotNull
        public final AmityException fromThrowable(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (throwable instanceof HttpException) {
                String errorBody;
                retrofit2.Response response = ((HttpException)throwable).response();
                String string = response != null && (response = response.errorBody()) != null ? response.string() : (errorBody = null);
                if (errorBody != null) {
                    AmityException amityException;
                    try {
                        JSONObject error = new JSONObject(errorBody);
                        int code = error.getInt("code");
                        String message = error.getString("message");
                        amityException = this.create(message, null, AmityError.Companion.from(code));
                    }
                    catch (Exception e) {
                        amityException = this.create("corrupted error format", null, AmityError.UNKNOWN);
                    }
                    return amityException;
                }
            }
            if (throwable instanceof IOException) {
                return this.create("network error", null, AmityError.CONNECTION_ERROR);
            }
            return this.create("unknown error", null, AmityError.UNKNOWN);
        }

        @NotNull
        public final AmityException fromResponse(@NotNull Response response) {
            AmityException amityException;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            try {
                String errorBody = response.peekBody(Long.MAX_VALUE).string();
                JSONObject error = new JSONObject(errorBody);
                int code = error.getInt("code");
                String message = error.getString("message");
                amityException = this.create(message, null, AmityError.Companion.from(code));
            }
            catch (Exception e) {
                amityException = this.create("corrupted error format", null, AmityError.UNKNOWN);
            }
            return amityException;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

