/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.social.comment;

import com.amity.socialcloud.sdk.api.core.ExperimentalAmityApi;
import com.amity.socialcloud.sdk.api.social.comment.create.AmityCommentCreationTarget;
import com.amity.socialcloud.sdk.api.social.comment.latest.AmityLatestCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentQueryType;
import com.amity.socialcloud.sdk.api.social.comment.reaction.AmityCommentReactionQuery;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.ekoapp.ekosdk.internal.usecase.comment.DeleteCommentUseCase;
import com.ekoapp.ekosdk.internal.usecase.comment.ObserveSingleCommentUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/api/social/comment/AmityCommentRepository;", "", "()V", "createComment", "Lcom/amity/socialcloud/sdk/api/social/comment/create/AmityCommentCreationTarget;", "getComment", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "commentId", "", "getComments", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentQueryType;", "getLatestComment", "Lcom/amity/socialcloud/sdk/api/social/comment/latest/AmityLatestCommentQueryType;", "getReactions", "Lcom/amity/socialcloud/sdk/api/social/comment/reaction/AmityCommentReactionQuery$Builder;", "hardDeleteComment", "Lio/reactivex/rxjava3/core/Completable;", "softDeleteComment", "amity-sdk_release"})
public final class AmityCommentRepository {
    @ExperimentalAmityApi
    @NotNull
    public final Flowable<AmityComment> getComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new ObserveSingleCommentUseCase().execute(commentId);
    }

    @NotNull
    public final AmityCommentQueryType getComments() {
        return new AmityCommentQueryType();
    }

    @NotNull
    public final AmityCommentCreationTarget createComment() {
        return new AmityCommentCreationTarget(null, 1, null);
    }

    @NotNull
    public final Completable softDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, false);
    }

    @NotNull
    public final Completable hardDeleteComment(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new DeleteCommentUseCase().execute(commentId, true);
    }

    @NotNull
    public final AmityCommentReactionQuery.Builder getReactions(@NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return new AmityCommentReactionQuery.Builder(commentId);
    }

    @NotNull
    public final AmityLatestCommentQueryType getLatestComment() {
        return new AmityLatestCommentQueryType();
    }
}

