/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.stream;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution;
import com.ekoapp.ekosdk.internal.usecase.stream.CreateStreamBroadcasterUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.CreateStreamSessionUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.DisposeStreamBroadcasterUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.GetStreamDataUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.SyncPendingSessionUseCase;
import com.ekoapp.ekosdk.internal.usecase.stream.UpdateStreamSessionUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public class StreamFunction
implements StreamFunctionInterface {
    @NonNull
    public Single<String> createStreamSession(@NotNull String streamId, @NotNull String title, @NotNull DateTime startedAt, @NotNull String resolution) {
        return new CreateStreamSessionUseCase().execute(streamId, title, startedAt, resolution);
    }

    @NotNull
    public Completable updateStreamSession(@NotNull String sessionId, @Nullable Long duration, @Nullable DateTime endedAt) {
        return new UpdateStreamSessionUseCase().execute(sessionId, duration, endedAt);
    }

    public void syncPendingSession() {
        new SyncPendingSessionUseCase().execute();
    }

    @NotNull
    public Single<PartialStreamData> getStreamData(@NotNull String streamId) {
        return new GetStreamDataUseCase().execute(streamId);
    }

    @NonNull
    public Single<Pair<String, String>> createVideoStreaming(@NonNull String title, @NonNull String description, @NonNull AmityBroadcastResolution resolution, @androidx.annotation.Nullable String thumbnailFileId) {
        return new CreateStreamBroadcasterUseCase().execute(title, description, resolution, thumbnailFileId);
    }

    @NonNull
    public Completable disposeVideoStreaming(@NonNull String streamId) {
        return new DisposeStreamBroadcasterUseCase().execute(streamId);
    }
}

