/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.reaction;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.amity.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010J&\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ&\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ*\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d\u00a8\u0006 "}, d2={"Lcom/amity/socialcloud/sdk/core/data/reaction/ReactionLocalDataStore;", "", "()V", "addReaction", "Lio/reactivex/rxjava3/core/Completable;", "reaction", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "reactionId", "", "referenceType", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionReferenceType;", "referenceId", "reactionName", "userId", "userDisplayName", "createdAt", "Lorg/joda/time/DateTime;", "updateAt", "createReaction", "getLatestReaction", "Lio/reactivex/rxjava3/core/Flowable;", "getReaction", "Lio/reactivex/rxjava3/core/Maybe;", "getReactionsPagingSource", "Landroidx/paging/PagingSource;", "", "removeReaction", "saveReactions", "reactions", "", "saveReactionsAndDeletePrevious", "ids", "amity-sdk_release"})
public final class ReactionLocalDataStore {
    @NotNull
    public final Completable saveReactionsAndDeletePrevious(@NotNull AmityReactionReferenceType referenceType, @NotNull List<String> ids, @NotNull List<? extends EkoReactionEntity> reactions) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.saveReactionsAndDeletePrevious$lambda-1(ids, reactions, referenceType));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026sert(reactions)\n        }");
        return completable;
    }

    @NotNull
    public final Completable saveReactions(@NotNull List<? extends EkoReactionEntity> reactions) {
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.saveReactions$lambda-2(reactions));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026sert(reactions)\n        }");
        return completable;
    }

    @NotNull
    public final Completable addReaction(@NotNull String reactionId, @NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId, @Nullable String userDisplayName, @Nullable DateTime createdAt, @Nullable DateTime updateAt) {
        Intrinsics.checkNotNullParameter((Object)reactionId, (String)"reactionId");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.addReaction$lambda-3(reactionId, referenceType, referenceId, reactionName, userId, createdAt, updateAt));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026reactionEntity)\n        }");
        return completable;
    }

    public static /* synthetic */ Completable addReaction$default(ReactionLocalDataStore reactionLocalDataStore, String string, AmityReactionReferenceType amityReactionReferenceType, String string2, String string3, String string4, String string5, DateTime dateTime, DateTime dateTime2, int n, Object object) {
        if ((n & 0x20) != 0) {
            string5 = null;
        }
        if ((n & 0x40) != 0) {
            dateTime = null;
        }
        if ((n & 0x80) != 0) {
            dateTime2 = null;
        }
        return reactionLocalDataStore.addReaction(string, amityReactionReferenceType, string2, string3, string4, string5, dateTime, dateTime2);
    }

    @NotNull
    public final Completable removeReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.removeReaction$lambda-4(referenceType, referenceId, userId, reactionName));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026e\n            )\n        }");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, EkoReactionEntity> getReactionsPagingSource(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        return UserDatabase.get().reactionPagingDao().getReactionPagingSource(referenceType, referenceId, reactionName);
    }

    @NotNull
    public final Flowable<EkoReactionEntity> getLatestReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Flowable<EkoReactionEntity> flowable = UserDatabase.get().reactionDao().getLatestReaction(referenceType.getValue(), referenceId, reactionName, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"get().reactionDao()\n    \u2026tionName, DateTime.now())");
        return flowable;
    }

    @NotNull
    public final Maybe<EkoReactionEntity> getReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Maybe<EkoReactionEntity> maybe = UserDatabase.get().reactionDao().getReactionByReferenceAndReactionName(referenceType.getValue(), referenceId, reactionName, userId);
        Intrinsics.checkNotNullExpressionValue(maybe, (String)"get().reactionDao()\n    \u2026,\n                userId)");
        return maybe;
    }

    @NotNull
    public final EkoReactionEntity createReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        EkoReactionEntity ekoReactionEntity = EkoReactionEntity.createReaction('!' + ObjectId.get().toHexString(), referenceType, referenceId, reactionName, userId, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)ekoReactionEntity, (String)"createReaction(\n        \u2026           null\n        )");
        return ekoReactionEntity;
    }

    @NotNull
    public final Completable addReaction(@NotNull EkoReactionEntity reaction) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.addReaction$lambda-6(reaction));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026}\n            }\n        }");
        return completable;
    }

    @NotNull
    public final Completable removeReaction(@NotNull EkoReactionEntity reaction) {
        Intrinsics.checkNotNullParameter((Object)reaction, (String)"reaction");
        Completable completable = Completable.fromAction(() -> ReactionLocalDataStore.removeReaction$lambda-8(reaction));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026}\n            }\n        }");
        return completable;
    }

    private static final void saveReactionsAndDeletePrevious$lambda-1(List $ids, List $reactions, AmityReactionReferenceType $referenceType) {
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Intrinsics.checkNotNullParameter((Object)$reactions, (String)"$reactions");
        Intrinsics.checkNotNullParameter((Object)((Object)$referenceType), (String)"$referenceType");
        EkoReactionDao ekoReactionDao = UserDatabase.get().reactionDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoReactionDao, (String)"get().reactionDao()");
        EkoReactionDao reactionDao = ekoReactionDao;
        Iterable $this$forEach$iv = $ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            reactionDao.deleteByReferenceIdAndUserId(it, $referenceType.getValue(), new SessionLocalDataStore().getActiveUserId());
        }
        reactionDao.insert($reactions);
    }

    private static final void saveReactions$lambda-2(List $reactions) {
        Intrinsics.checkNotNullParameter((Object)$reactions, (String)"$reactions");
        EkoReactionDao ekoReactionDao = UserDatabase.get().reactionDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoReactionDao, (String)"get().reactionDao()");
        EkoReactionDao reactionDao = ekoReactionDao;
        reactionDao.insert($reactions);
    }

    private static final void addReaction$lambda-3(String $reactionId, AmityReactionReferenceType $referenceType, String $referenceId, String $reactionName, String $userId, DateTime $createdAt, DateTime $updateAt) {
        Intrinsics.checkNotNullParameter((Object)$reactionId, (String)"$reactionId");
        Intrinsics.checkNotNullParameter((Object)((Object)$referenceType), (String)"$referenceType");
        Intrinsics.checkNotNullParameter((Object)$referenceId, (String)"$referenceId");
        Intrinsics.checkNotNullParameter((Object)$reactionName, (String)"$reactionName");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        EkoReactionEntity reactionEntity = EkoReactionEntity.createReaction($reactionId, $referenceType, $referenceId, $reactionName, $userId, $createdAt, $updateAt);
        reactionDao.insert((EkoObject)reactionEntity);
    }

    private static final void removeReaction$lambda-4(AmityReactionReferenceType $referenceType, String $referenceId, String $userId, String $reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)$referenceType), (String)"$referenceType");
        Intrinsics.checkNotNullParameter((Object)$referenceId, (String)"$referenceId");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        Intrinsics.checkNotNullParameter((Object)$reactionName, (String)"$reactionName");
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        reactionDao.deleteByPrimaryKey($referenceType.getValue(), $referenceId, $userId, $reactionName);
    }

    private static final void addReaction$lambda-6$lambda-5(EkoReactionDao $reactionDao, EkoReactionEntity $reaction, UserDatabase $userDatabase) {
        Intrinsics.checkNotNullParameter((Object)$reaction, (String)"$reaction");
        $reactionDao.insert((EkoObject)$reaction);
        switch (WhenMappings.$EnumSwitchMapping$0[AmityReactionReferenceType.Companion.enumOf($reaction.getReferenceType()).ordinal()]) {
            case 1: {
                PostDao postDao = $userDatabase.postDao();
                PostEntity post = postDao.getByIdNow($reaction.getReferenceId());
                if (post == null) break;
                AmityReactionMap reactionMap = post.getReactions();
                post.setReactionCount(post.getReactionCount() + 1);
                Map map = reactionMap;
                String string = $reaction.getReactionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                String string2 = string;
                Integer n = post.getReactions().getCount($reaction.getReactionName()) + 1;
                map.put(string2, n);
                post.setReactions(reactionMap);
                postDao.update((EkoObject)post);
                break;
            }
            case 2: {
                EkoMessageDao messageDao = $userDatabase.messageDao();
                EkoMessageEntity message = messageDao.getByIdNow($reaction.getReferenceId());
                if (message == null) break;
                AmityReactionMap reactionMap = message.getReactions();
                message.setReactionCount(message.getReactionCount() + 1);
                Map map = reactionMap;
                String string = $reaction.getReactionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                String string3 = string;
                Integer n = message.getReactions().getCount($reaction.getReactionName()) + 1;
                map.put(string3, n);
                message.setReactions(reactionMap);
                messageDao.update(message);
                break;
            }
            case 3: {
                EkoCommentDao commentDao = $userDatabase.commentDao();
                CommentEntity comment = commentDao.getByIdNow($reaction.getReferenceId());
                if (comment == null) break;
                AmityReactionMap reactionMap = comment.getReactions();
                comment.setReactionCount(comment.getReactionCount() + 1);
                Map map = reactionMap;
                String string = $reaction.getReactionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
                String string4 = string;
                Integer n = comment.getReactions().getCount($reaction.getReactionName()) + 1;
                map.put(string4, n);
                comment.setReactions(reactionMap);
                commentDao.update((EkoObject)comment);
                if (!Intrinsics.areEqual((Object)comment.getReferenceType(), (Object)"post")) break;
                PostDao postDao = $userDatabase.postDao();
                postDao.updatePost(comment.getReferenceId());
            }
        }
    }

    private static final void addReaction$lambda-6(EkoReactionEntity $reaction) {
        Intrinsics.checkNotNullParameter((Object)$reaction, (String)"$reaction");
        UserDatabase userDatabase = UserDatabase.get();
        EkoReactionDao reactionDao = userDatabase.reactionDao();
        userDatabase.runInTransaction(() -> ReactionLocalDataStore.addReaction$lambda-6$lambda-5(reactionDao, $reaction, userDatabase));
    }

    private static final void removeReaction$lambda-8$lambda-7(EkoReactionEntity $reaction, EkoReactionDao $reactionDao, UserDatabase $userDatabase) {
        Intrinsics.checkNotNullParameter((Object)$reaction, (String)"$reaction");
        String string = $reaction.getReactionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reaction.reactionName");
        String reactionName = string;
        $reactionDao.delete($reaction);
        switch (WhenMappings.$EnumSwitchMapping$0[AmityReactionReferenceType.Companion.enumOf($reaction.getReferenceType()).ordinal()]) {
            case 1: {
                PostDao postDao = $userDatabase.postDao();
                PostEntity post = postDao.getByIdNow($reaction.getReferenceId());
                if (post == null) break;
                AmityReactionMap reactionMap = post.getReactions();
                int totalReactionCount = Math.max(0, post.getReactionCount() - 1);
                int reactionCount = Math.max(0, post.getReactions().getCount(reactionName) - 1);
                post.setReactionCount(totalReactionCount);
                Integer n = reactionCount;
                ((Map)reactionMap).put(reactionName, n);
                post.setReactions(reactionMap);
                postDao.update((EkoObject)post);
                break;
            }
            case 2: {
                EkoMessageDao messageDao = $userDatabase.messageDao();
                EkoMessageEntity message = messageDao.getByIdNow($reaction.getReferenceId());
                if (message == null) break;
                AmityReactionMap reactionMap = message.getReactions();
                int totalReactionCount = Math.max(0, message.getReactionCount() - 1);
                int reactionCount = Math.max(0, message.getReactions().getCount(reactionName) - 1);
                message.setReactionCount(totalReactionCount);
                Integer n = reactionCount;
                ((Map)reactionMap).put(reactionName, n);
                message.setReactions(reactionMap);
                messageDao.update(message);
                break;
            }
            case 3: {
                EkoCommentDao commentDao = $userDatabase.commentDao();
                CommentEntity comment = commentDao.getByIdNow($reaction.getReferenceId());
                if (comment == null) break;
                AmityReactionMap reactionMap = comment.getReactions();
                int totalReactionCount = Math.max(0, comment.getReactionCount() - 1);
                int reactionCount = Math.max(0, comment.getReactions().getCount(reactionName) - 1);
                comment.setReactionCount(totalReactionCount);
                Integer n = reactionCount;
                ((Map)reactionMap).put(reactionName, n);
                comment.setReactions(reactionMap);
                commentDao.update((EkoObject)comment);
                if (!Intrinsics.areEqual((Object)comment.getReferenceType(), (Object)"post")) break;
                PostDao postDao = $userDatabase.postDao();
                postDao.updatePost(comment.getReferenceId());
            }
        }
    }

    private static final void removeReaction$lambda-8(EkoReactionEntity $reaction) {
        Intrinsics.checkNotNullParameter((Object)$reaction, (String)"$reaction");
        UserDatabase userDatabase = UserDatabase.get();
        EkoReactionDao reactionDao = userDatabase.reactionDao();
        userDatabase.runInTransaction(() -> ReactionLocalDataStore.removeReaction$lambda-8$lambda-7($reaction, reactionDao, userDatabase));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityReactionReferenceType.values().length];
            nArray[AmityReactionReferenceType.POST.ordinal()] = 1;
            nArray[AmityReactionReferenceType.MESSAGE.ordinal()] = 2;
            nArray[AmityReactionReferenceType.COMMENT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

