/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.api.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.api.core.notification.AmityNotification;
import com.amity.socialcloud.sdk.api.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.api.core.presence.AmityPresenceService;
import com.amity.socialcloud.sdk.api.core.presence.AmityUserPresenceRepository;
import com.amity.socialcloud.sdk.api.core.reaction.AmityReactionRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.api.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.api.core.user.notification.AmityUserNotification;
import com.amity.socialcloud.sdk.api.core.user.update.AmityUserUpdate;
import com.amity.socialcloud.sdk.chat.data.marker.user.ObserveUserMarker;
import com.amity.socialcloud.sdk.chat.data.marker.user.UserUnreadModelMapper;
import com.amity.socialcloud.sdk.core.MarkReadEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.presence.PresenceSyncEngine;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.content.AmityContentCheck;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.unread.UserUnread;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.data.stream.StreamFunction;
import com.ekoapp.ekosdk.internal.UserMarkerEntity;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100J\f\u00102\u001a\b\u0012\u0004\u0012\u00020300J\r\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\u0006\u00107\u001a\u00020\u0004J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\b\u0010?\u001a\u0004\u0018\u00010@J\u0006\u0010A\u001a\u00020(J\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020GJ\u0006\u0010H\u001a\u00020IJ\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020MJ\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\b00J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P00J\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001000J\u0006\u0010R\u001a\u00020SJ\u0006\u0010T\u001a\u00020(J\u0006\u0010U\u001a\u00020(J\u000e\u0010V\u001a\u00020(2\u0006\u0010W\u001a\u00020\u0004J\u0016\u0010V\u001a\u00020(2\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020YJ\b\u0010Z\u001a\u00020[H\u0002J\u0006\u0010\\\u001a\u00020[J\u0016\u0010]\u001a\u00020(2\u0006\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004J\u0006\u0010`\u001a\u00020[J\u0016\u0010a\u001a\u00020(2\u0006\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004J\u000e\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eJ\u0006\u0010f\u001a\u00020(J\u0006\u0010g\u001a\u00020(J\u0006\u0010h\u001a\u00020iR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/amity/socialcloud/sdk/core/CoreClient;", "", "()V", "TAG", "", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "currentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "markReadEngine", "Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "markerSyncEngine", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "presenceSyncEngine", "Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "getPresenceSyncEngine$amity_sdk_release", "()Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;", "setPresenceSyncEngine$amity_sdk_release", "(Lcom/amity/socialcloud/sdk/core/presence/PresenceSyncEngine;)V", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getContentCheck", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentCheck;", "getCurrentUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/api/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/model/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "newReactionRepository", "Lcom/amity/socialcloud/sdk/api/core/reaction/AmityReactionRepository;", "newUserPresenceRepository", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityUserPresenceRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/api/core/user/notification/AmityUserNotification;", "notifications", "Lcom/amity/socialcloud/sdk/api/core/notification/AmityNotification;", "observeSessionState", "observeUserUnread", "Lcom/amity/socialcloud/sdk/model/core/unread/UserUnread;", "observeUserUnreadCount", "presence", "Lcom/amity/socialcloud/sdk/api/core/presence/AmityPresenceService;", "registerDeviceForPushNotification", "registerPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "setupSessionComponents", "", "startMarkerSyncing", "startReading", "subChannelId", "channelId", "stopMarkerSyncing", "stopReading", "subscription", "Lcom/amity/socialcloud/sdk/api/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "unregisterPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/api/core/user/update/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class CoreClient {
    @NotNull
    public static final CoreClient INSTANCE = new CoreClient();
    @NotNull
    private static final String TAG = "AmityCoreClient";
    private static int millisTimeDiff;
    @Nullable
    private static AmityMqttClient mqttClient;
    @Nullable
    private static EkoSocket socketClient;
    @Nullable
    private static TokenRenewalSessionComponent renewalManager;
    @Nullable
    private static PresenceSyncEngine presenceSyncEngine;
    @NotNull
    private static final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @NotNull
    private static final AppEventBus appEventBus;
    @NotNull
    private static final SessionStateEventBus sessionStateEventBus;
    @NotNull
    private static final SessionStateManager sessionStateManager;
    @Nullable
    private static MarkerSyncEngine markerSyncEngine;
    @Nullable
    private static MarkReadEngine markReadEngine;

    private CoreClient() {
    }

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @Nullable
    public final PresenceSyncEngine getPresenceSyncEngine$amity_sdk_release() {
        return presenceSyncEngine;
    }

    public final void setPresenceSyncEngine$amity_sdk_release(@Nullable PresenceSyncEngine presenceSyncEngine) {
        CoreClient.presenceSyncEngine = presenceSyncEngine;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject result = CompletableSubject.create();
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao apiKeyDao = EkoDatabase.get().apiKeyDao();
        Maybe.zip((MaybeSource)((MaybeSource)apiKeyDao.getCurrentApiKey()), (MaybeSource)((MaybeSource)httpUrlDao.getCurrentHttpUrl()), (MaybeSource)((MaybeSource)socketUrlDao.getCurrentSocketUrl()), (MaybeSource)((MaybeSource)mqttUrlDao.getCurrentMqttUrl()), CoreClient::setup$lambda-0).subscribeOn(Schedulers.io()).doOnSuccess(arg_0 -> CoreClient.setup$lambda-1(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao, arg_0)).doOnComplete(() -> CoreClient.setup$lambda-2(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey)).flatMapCompletable(CoreClient::setup$lambda-3).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, AmityEndpoint.SG.INSTANCE);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return this.registerPushNotification();
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return this.unregisterPushNotification();
    }

    @NotNull
    public final Completable registerPushNotification() {
        return new RegisterDeviceForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable unregisterPushNotification() {
        return new UnregisterAllUsersForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null || socketClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n\t\t\tCompletable.complete()\n\t\t}");
        } else {
            EkoSocket ekoSocket = socketClient;
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            boolean bl = isLegacyVersion = sessionHandler == null;
            if (this.getCurrentSessionState() instanceof SessionState.Establishing) {
                throw SessionError.INSTANCE.fromState(this.getCurrentSessionState());
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler it = sessionHandler2;
            boolean bl2 = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new AmitySessionEstablisher.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        return new LogoutUseCase().execute();
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final AmityReactionRepository newReactionRepository() {
        return new AmityReactionRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "6.14.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityNotification notifications() {
        return new AmityNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return sessionStateEventBus.observe();
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.startReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        MarkReadEngine markReadEngine = CoreClient.markReadEngine;
        if (markReadEngine == null || (markReadEngine = markReadEngine.stopReading(subChannelId, channelId)) == null) {
            Completable completable = Completable.never();
            markReadEngine = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
        }
        return markReadEngine;
    }

    public final void startMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.startMarkerSync();
        }
    }

    public final void stopMarkerSyncing() {
        block0: {
            MarkerSyncEngine markerSyncEngine = CoreClient.markerSyncEngine;
            if (markerSyncEngine == null) break block0;
            markerSyncEngine.stopMarkerSync();
        }
    }

    @NotNull
    public final Flowable<Integer> observeUserUnreadCount() {
        Flowable flowable = new ObserveUserMarker().execute().map(CoreClient::observeUserUnreadCount$lambda-5);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026().map { it.unreadCount }");
        return flowable;
    }

    @NotNull
    public final Flowable<UserUnread> observeUserUnread() {
        Flowable flowable = new ObserveUserMarker().execute().map(new UserUnreadModelMapper()::map);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ObserveUserMarker().exec\u2026UnreadModelMapper()::map)");
        return flowable;
    }

    @NotNull
    public final AmityPresenceService presence() {
        return new AmityPresenceService(presenceSyncEngine);
    }

    @NotNull
    public final AmityUserPresenceRepository newUserPresenceRepository() {
        return new AmityUserPresenceRepository();
    }

    private final void setupSessionComponents() {
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            socketClient = new EkoSocket(sessionLifeCycleEventBus, sessionStateEventBus);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            presenceSyncEngine = new PresenceSyncEngine(sessionLifeCycleEventBus, sessionStateEventBus);
            new AmityHttpClient(sessionLifeCycleEventBus, sessionStateEventBus);
            new DatabaseSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new UserSettingSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new TokenWatcherSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            markerSyncEngine = new MarkerSyncEngine(sessionLifeCycleEventBus, sessionStateEventBus);
            markReadEngine = new MarkReadEngine(sessionLifeCycleEventBus, sessionStateEventBus);
        }
    }

    private static final Pair setup$lambda-0(EkoApiKey apiKey, EkoHttpUrl httpEntity, EkoSocketUrl socketEntity, EkoMqttUrl mqttEntity) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)httpEntity, (String)"httpEntity");
        Intrinsics.checkNotNullParameter((Object)socketEntity, (String)"socketEntity");
        Intrinsics.checkNotNullParameter((Object)mqttEntity, (String)"mqttEntity");
        String string = httpEntity.getHttpUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpEntity.httpUrl");
        String string2 = socketEntity.getSocketUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"socketEntity.socketUrl");
        String string3 = mqttEntity.getMqttUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mqttEntity.mqttUrl");
        AmityEndpoint.CUSTOM storedEndpoint = new AmityEndpoint.CUSTOM(string, string2, string3);
        return new Pair((Object)apiKey, (Object)storedEndpoint);
    }

    private static final void setup$lambda-1(String $newHttpUrl, String $newSocketUrl, String $newMqttUrl, String $apiKey, EkoHttpUrlDao $httpUrlDao, EkoSocketUrlDao $socketUrlDao, EkoMqttUrlDao $mqttUrlDao, EkoApiKeyDao $apiKeyDao, Pair setupPair) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        Intrinsics.checkNotNullParameter((Object)setupPair, (String)"setupPair");
        String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
        String storedApiKey = string;
        String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
        String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
        String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
        if (!(Objects.equal((Object)storedHttpUrl, (Object)$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)$apiKey))) {
            Object[] objectArray = new Object[]{$apiKey, $newHttpUrl, $newSocketUrl, $newMqttUrl};
            AmityLog.INSTANCE.tag(TAG).e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", objectArray);
            AmityLog.INSTANCE.tag(TAG).e("deleting user database", new Object[0]);
            INSTANCE.logout();
            $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
            $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
            $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
            $apiKeyDao.insert(EkoApiKey.create($apiKey));
        }
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final void setup$lambda-2(EkoHttpUrlDao $httpUrlDao, String $newHttpUrl, EkoSocketUrlDao $socketUrlDao, String $newSocketUrl, EkoMqttUrlDao $mqttUrlDao, String $newMqttUrl, EkoApiKeyDao $apiKeyDao, String $apiKey) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
        $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
        $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
        $apiKeyDao.insert(EkoApiKey.create($apiKey));
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final CompletableSource setup$lambda-3(Pair it) {
        return (CompletableSource)Completable.complete();
    }

    private static final Integer observeUserUnreadCount$lambda-5(UserMarkerEntity it) {
        return it.getUnreadCount();
    }

    static {
        sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        appEventBus = new AppEventBus();
        sessionStateEventBus = new SessionStateEventBus();
        AppEventBus appEventBus = CoreClient.appEventBus;
        SessionStateEventBus sessionStateEventBus = CoreClient.sessionStateEventBus;
        SessionLifeCycleEventBus sessionLifeCycleEventBus = CoreClient.sessionLifeCycleEventBus;
        sessionStateManager = new SessionStateManager(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
    }
}

