/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.domain.message;

import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository;
import com.amity.socialcloud.sdk.core.domain.ComposerUseCase;
import com.amity.socialcloud.sdk.core.domain.file.AudioGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.FileGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase;
import com.amity.socialcloud.sdk.core.domain.file.VideoGetUseCase;
import com.amity.socialcloud.sdk.core.domain.reaction.MyReactionsGetUseCase;
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase;
import com.amity.socialcloud.sdk.helper.core.mention.AmityMentionee;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.AmityImage;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.ekoapp.ekosdk.internal.usecase.message.IsMessageFlaggedByMeUseCase;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/amity/socialcloud/sdk/chat/domain/message/MessageComposerUseCase;", "Lcom/amity/socialcloud/sdk/core/domain/ComposerUseCase;", "()V", "addData", "", "message", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "addMarker", "addMentioneeUser", "addMyFlag", "addMyReactions", "addUser", "execute", "getFile", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "getThumbnailImage", "Lcom/amity/socialcloud/sdk/model/core/file/AmityImage;", "amity-sdk_release"})
public final class MessageComposerUseCase
extends ComposerUseCase {
    @NotNull
    public final AmityMessage execute(@NotNull AmityMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.addMyReactions(message);
        this.addMyFlag(message);
        this.addUser(message);
        this.addMentioneeUser(message);
        this.addData(message);
        this.addMarker(message);
        return message;
    }

    private final void addMyReactions(AmityMessage message) {
        message.setMyReactions$amity_sdk_release(new MyReactionsGetUseCase().execute(AmityReactionReferenceType.MESSAGE, message.getMessageId()));
    }

    private final void addMyFlag(AmityMessage message) {
        message.setFlaggedByMe$amity_sdk_release(new IsMessageFlaggedByMeUseCase().execute(message.getMessageId()));
    }

    private final void addUser(AmityMessage message) {
        message.setUser$amity_sdk_release(new UserGetUseCase().execute(message.getCreatorId()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMentioneeUser(AmityMessage message) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = message.getMentionees();
        AmityMessage amityMessage = message;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityMentionee amityMentionee = (AmityMentionee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof AmityMentionee.USER) {
                ((AmityMentionee.USER)it).setUser$amity_sdk_release(new UserGetUseCase().execute(((AmityMentionee.USER)it).getUserId()));
            }
            collection.add(it);
        }
        amityMessage.setMentionees$amity_sdk_release((List)destination$iv$iv);
    }

    private final void addData(AmityMessage message) {
        AmityFileInfo file = this.getFile(message);
        AmityImage thumbnailFile = this.getThumbnailImage(message);
        String string = message.getMessageId();
        AmityMessage.DataType dataType = message.getDataType();
        JsonObject jsonObject = message.getRawData$amity_sdk_release();
        if (jsonObject == null) {
            jsonObject = new JsonObject();
        }
        AmityMessage.Data data = AmityMessage.Data.Companion.from$amity_sdk_release(string, dataType, jsonObject, file, thumbnailFile);
        message.setData$amity_sdk_release(data);
    }

    private final AmityFileInfo getFile(AmityMessage message) {
        AmityFileInfo amityFileInfo;
        String fileId;
        JsonObject jsonObject = message.getRawData$amity_sdk_release();
        String string = fileId = jsonObject != null && (jsonObject = jsonObject.get("fileId")) != null ? jsonObject.getAsString() : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[message.getDataType().ordinal()]) {
                case 1: {
                    amityFileInfo = new ImageGetUseCase().execute(it);
                    break;
                }
                case 2: {
                    amityFileInfo = new FileGetUseCase().execute(it);
                    break;
                }
                case 3: {
                    amityFileInfo = new AudioGetUseCase().execute(it);
                    break;
                }
                case 4: {
                    amityFileInfo = new VideoGetUseCase().execute(it);
                    break;
                }
                default: {
                    amityFileInfo = null;
                }
            }
        } else {
            amityFileInfo = null;
        }
        return amityFileInfo;
    }

    private final AmityImage getThumbnailImage(AmityMessage message) {
        AmityImage amityImage;
        String thumbnailFileId;
        JsonObject jsonObject = message.getRawData$amity_sdk_release();
        String string = thumbnailFileId = jsonObject != null && (jsonObject = jsonObject.get("thumbnailFileId")) != null ? jsonObject.getAsString() : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            amityImage = new ImageGetUseCase().execute(it);
        } else {
            amityImage = null;
        }
        return amityImage;
    }

    private final void addMarker(AmityMessage message) {
        message.setReadCount$amity_sdk_release(new MessageMarkerRepository().getReadCount(message.getMessageId()));
        message.setDeliveredCount$amity_sdk_release(new MessageMarkerRepository().getDeliveredCount(message.getMessageId()));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AmityMessage.DataType.values().length];
            nArray[AmityMessage.DataType.IMAGE.ordinal()] = 1;
            nArray[AmityMessage.DataType.FILE.ordinal()] = 2;
            nArray[AmityMessage.DataType.AUDIO.ordinal()] = 3;
            nArray[AmityMessage.DataType.VIDEO.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

