/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.channel;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.chat.data.channel.ChannelHelper;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\nJG\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJQ\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u001e\u0010%\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u000fJ\u000e\u0010(\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u000f\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/channel/ChannelLocalDataStore;", "", "()V", "getAllJoinedChannels", "Lio/reactivex/rxjava3/core/Flowable;", "", "Lcom/ekoapp/ekosdk/EkoChannelWithMembershipAndExtra;", "getChannel", "Lcom/ekoapp/ekosdk/internal/EkoChannelEntity;", "channelId", "", "getChannelByInternalId", "internalChannelId", "getChannelPagingSource", "Landroidx/paging/PagingSource;", "", "types", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "filter", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;", "includingTags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "excludingTags", "isDeleted", "", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;)Landroidx/paging/PagingSource;", "getLatestChannel", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/util/Set;Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannelFilter;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "hasInLocal", "observeChannel", "saveChannels", "Lio/reactivex/rxjava3/core/Completable;", "channels", "updateDefaultSubChannelMessageCount", "subChannelId", "segment", "updateLastActivity", "updateMarkerHash", "", "hash", "amity-sdk_release"})
public final class ChannelLocalDataStore {
    @NotNull
    public final Completable saveChannels(@NotNull List<? extends EkoChannelEntity> channels) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.saveChannels$lambda-0(channels));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026.save(channels)\n        }");
        return completable;
    }

    @Nullable
    public final EkoChannelEntity getChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return UserDatabase.get().channelDao().getByIdNow(channelId);
    }

    @Nullable
    public final EkoChannelEntity getChannelByInternalId(@NotNull String internalChannelId) {
        Intrinsics.checkNotNullParameter((Object)internalChannelId, (String)"internalChannelId");
        return UserDatabase.get().channelDao().getByInternalIdNow(internalChannelId);
    }

    @NotNull
    public final Flowable<EkoChannelEntity> observeChannel(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return UserDatabase.get().channelDao().getChannel(channelId);
    }

    @NotNull
    public final Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannels() {
        return UserDatabase.get().channelDao().getAllJoinedChannels(new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final Completable updateDefaultSubChannelMessageCount(@NotNull String channelId, @NotNull String subChannelId, int segment) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateDefaultSubChannelMessageCount$lambda-1(this, subChannelId, channelId, segment)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable updateLastActivity(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Completable completable = Completable.fromAction(() -> ChannelLocalDataStore.updateLastActivity$lambda-2(channelId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction {\n           \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final PagingSource<Integer, EkoChannelEntity> getChannelPagingSource(@NotNull Set<? extends AmityChannel.Type> types, @NotNull AmityChannelFilter filter, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        return UserDatabase.get().channelPagingDao().getChannelPagingSource(types, filter, includingTags, excludingTags, isDeleted);
    }

    @NotNull
    public final Flowable<EkoChannelEntity> getLatestChannel(@NotNull Set<? extends AmityChannel.Type> types, @NotNull AmityChannelFilter filter, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        EkoChannelDao ekoChannelDao = UserDatabase.get().channelDao();
        Collection $this$toTypedArray$iv = ChannelHelper.INSTANCE.getChannelTypes(types);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String string = new SessionLocalDataStore().getActiveUserId();
        $this$toTypedArray$iv = filter.getMemberships();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        $this$toTypedArray$iv = includingTags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        $this$toTypedArray$iv = excludingTags;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray4, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        int n = ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now()");
        return ekoChannelDao.getLatestChannel(stringArray, string, stringArray2, stringArray3, stringArray4, isDeleted, n, nonce, dateTime);
    }

    public final boolean hasInLocal(@NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Ref.BooleanRef hasInLocal = new Ref.BooleanRef();
        Completable.fromCallable(() -> ChannelLocalDataStore.hasInLocal$lambda-3(channelId, hasInLocal)).subscribeOn(Schedulers.io()).blockingAwait();
        return hasInLocal.element;
    }

    public final void updateMarkerHash(@NotNull String channelId, int hash) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        UserDatabase.get().channelDao().updateMarkerHash(channelId, hash);
    }

    private static final void saveChannels$lambda-0(List $channels) {
        Intrinsics.checkNotNullParameter((Object)$channels, (String)"$channels");
        UserDatabase.get().channelDao().save($channels);
    }

    private static final void updateDefaultSubChannelMessageCount$lambda-1(ChannelLocalDataStore this$0, String $subChannelId, String $channelId, int $segment) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$subChannelId, (String)"$subChannelId");
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        EkoChannelEntity cachedChannel = this$0.getChannelByInternalId($subChannelId);
        if (cachedChannel != null) {
            UserDatabase.get().channelDao().updateMessageCount($channelId, $segment);
        }
    }

    private static final void updateLastActivity$lambda-2(String $channelId) {
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        EkoChannelDao ekoChannelDao = UserDatabase.get().channelDao();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now()");
        ekoChannelDao.updateLastActivity($channelId, dateTime);
    }

    private static final Unit hasInLocal$lambda-3(String $channelId, Ref.BooleanRef $hasInLocal) {
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        Intrinsics.checkNotNullParameter((Object)$hasInLocal, (String)"$hasInLocal");
        EkoChannelDao channelDao = UserDatabase.get().channelDao();
        EkoChannelEntity entity = channelDao.getByIdNow($channelId);
        if (entity != null) {
            $hasInLocal.element = true;
        }
        return Unit.INSTANCE;
    }
}

