/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core;

import com.amity.socialcloud.sdk.api.core.endpoint.AmityEndpoint;
import com.amity.socialcloud.sdk.api.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.api.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.api.core.notification.AmityNotification;
import com.amity.socialcloud.sdk.api.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.api.core.reaction.AmityReactionRepository;
import com.amity.socialcloud.sdk.api.core.session.AmitySessionEstablisher;
import com.amity.socialcloud.sdk.api.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.api.core.user.notification.AmityUserNotification;
import com.amity.socialcloud.sdk.api.core.user.update.AmityUserUpdate;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.content.AmityContentCheck;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.model.core.session.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.model.core.session.SessionHandler;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.data.stream.StreamFunction;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0'J\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0006\u0010.\u001a\u00020\u0004J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\b\u00106\u001a\u0004\u0018\u000107J\u0006\u00108\u001a\u00020\u001bJ\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020>J\b\u0010?\u001a\u00020@H\u0007J\u0006\u0010A\u001a\u00020BJ\f\u0010C\u001a\b\u0012\u0004\u0012\u00020%0'J\b\u0010D\u001a\u00020\u001bH\u0007J\u0006\u0010E\u001a\u00020\u001bJ\u000e\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u0004J\u0016\u0010F\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020KH\u0002J\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020\u001bH\u0007J\u0006\u0010Q\u001a\u00020\u001bJ\b\u0010R\u001a\u00020\u001dH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/amity/socialcloud/sdk/api/core/AmityCoreClient;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "editUser", "Lcom/amity/socialcloud/sdk/api/core/user/update/AmityUserUpdate$Builder;", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getContentCheck", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/model/core/content/AmityContentCheck;", "getCurrentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/model/core/session/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/api/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/model/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/api/core/session/AmitySessionEstablisher$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/model/core/session/SessionHandler;", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/api/core/file/AmityFileRepository;", "newReactionRepository", "Lcom/amity/socialcloud/sdk/api/core/reaction/AmityReactionRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/api/core/user/notification/AmityUserNotification;", "notifications", "Lcom/amity/socialcloud/sdk/api/core/notification/AmityNotification;", "observeSessionState", "registerDeviceForPushNotification", "registerPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/api/core/endpoint/AmityEndpoint;", "setupSessionComponents", "", "subscription", "Lcom/amity/socialcloud/sdk/api/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "unregisterPushNotification", "updateUser", "amity-sdk_release"})
public final class AmityCoreClient {
    @NotNull
    public static final AmityCoreClient INSTANCE = new AmityCoreClient();
    private static final String TAG = AmityCoreClient.class.getName();
    private static int millisTimeDiff;
    @Nullable
    private static AmityMqttClient mqttClient;
    @Nullable
    private static EkoSocket socketClient;
    @Nullable
    private static TokenRenewalSessionComponent renewalManager;
    @NotNull
    private static final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    @NotNull
    private static final AppEventBus appEventBus;
    @NotNull
    private static final SessionStateEventBus sessionStateEventBus;
    @NotNull
    private static final SessionStateManager sessionStateManager;

    private AmityCoreClient() {
    }

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject result = CompletableSubject.create();
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao apiKeyDao = EkoDatabase.get().apiKeyDao();
        Maybe.zip((MaybeSource)((MaybeSource)apiKeyDao.getCurrentApiKey()), (MaybeSource)((MaybeSource)httpUrlDao.getCurrentHttpUrl()), (MaybeSource)((MaybeSource)socketUrlDao.getCurrentSocketUrl()), (MaybeSource)((MaybeSource)mqttUrlDao.getCurrentMqttUrl()), AmityCoreClient::setup$lambda-0).subscribeOn(Schedulers.io()).doOnSuccess(arg_0 -> AmityCoreClient.setup$lambda-1(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao, arg_0)).doOnComplete(() -> AmityCoreClient.setup$lambda-2(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey)).flatMapCompletable(AmityCoreClient::setup$lambda-3).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, AmityEndpoint.SG.INSTANCE);
    }

    @Deprecated(message="Use registerPushNotification() instead")
    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return this.registerPushNotification();
    }

    @Deprecated(message="Use unregisterPushNotification() instead")
    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return this.unregisterPushNotification();
    }

    @NotNull
    public final Completable registerPushNotification() {
        return new RegisterDeviceForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable unregisterPushNotification() {
        return new UnregisterAllUsersForNotificationUseCase().execute();
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null || socketClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"{\n            Completable.complete()\n        }");
        } else {
            EkoSocket ekoSocket = socketClient;
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @NotNull
    public final AmitySessionEstablisher.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            isLegacyVersion = sessionHandler == null;
            SessionState currentSessionState = this.getCurrentSessionState();
            if (currentSessionState instanceof SessionState.Establishing) {
                throw SessionError.INSTANCE.fromState(currentSessionState);
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler it = sessionHandler2;
            boolean bl = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new AmitySessionEstablisher.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        return new LogoutUseCase().execute();
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder editUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @Deprecated(message="Use editUser() instead")
    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return this.editUser();
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final AmityReactionRepository newReactionRepository() {
        return new AmityReactionRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "6.11.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @Deprecated(message="Use notifications.user() instead")
    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityNotification notifications() {
        return new AmityNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return sessionStateEventBus.observe();
    }

    private final void setupSessionComponents() {
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            socketClient = new EkoSocket(sessionLifeCycleEventBus, sessionStateEventBus);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            new AmityHttpClient(sessionLifeCycleEventBus, sessionStateEventBus);
            new DatabaseSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new UserSettingSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new TokenWatcherSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
        }
    }

    private static final Pair setup$lambda-0(EkoApiKey apiKey, EkoHttpUrl httpEntity, EkoSocketUrl socketEntity, EkoMqttUrl mqttEntity) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)httpEntity, (String)"httpEntity");
        Intrinsics.checkNotNullParameter((Object)socketEntity, (String)"socketEntity");
        Intrinsics.checkNotNullParameter((Object)mqttEntity, (String)"mqttEntity");
        String string = httpEntity.getHttpUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpEntity.httpUrl");
        String string2 = socketEntity.getSocketUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"socketEntity.socketUrl");
        String string3 = mqttEntity.getMqttUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mqttEntity.mqttUrl");
        AmityEndpoint.CUSTOM storedEndpoint = new AmityEndpoint.CUSTOM(string, string2, string3);
        return new Pair((Object)apiKey, (Object)storedEndpoint);
    }

    private static final void setup$lambda-1(String $newHttpUrl, String $newSocketUrl, String $newMqttUrl, String $apiKey, EkoHttpUrlDao $httpUrlDao, EkoSocketUrlDao $socketUrlDao, EkoMqttUrlDao $mqttUrlDao, EkoApiKeyDao $apiKeyDao, Pair setupPair) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        Intrinsics.checkNotNullParameter((Object)setupPair, (String)"setupPair");
        String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
        String storedApiKey = string;
        String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
        String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
        String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
        if (!(Objects.equal((Object)storedHttpUrl, (Object)$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)$apiKey))) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Object[] objectArray = new Object[]{$apiKey, $newHttpUrl, $newSocketUrl, $newMqttUrl};
            AmityLog.INSTANCE.tag(string2).e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", objectArray);
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AmityLog.INSTANCE.tag(string3).e("deleting user database", new Object[0]);
            INSTANCE.logout();
            $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
            $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
            $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
            $apiKeyDao.insert(EkoApiKey.create($apiKey));
        }
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final void setup$lambda-2(EkoHttpUrlDao $httpUrlDao, String $newHttpUrl, EkoSocketUrlDao $socketUrlDao, String $newSocketUrl, EkoMqttUrlDao $mqttUrlDao, String $newMqttUrl, EkoApiKeyDao $apiKeyDao, String $apiKey) {
        Intrinsics.checkNotNullParameter((Object)$newHttpUrl, (String)"$newHttpUrl");
        Intrinsics.checkNotNullParameter((Object)$newSocketUrl, (String)"$newSocketUrl");
        Intrinsics.checkNotNullParameter((Object)$newMqttUrl, (String)"$newMqttUrl");
        Intrinsics.checkNotNullParameter((Object)$apiKey, (String)"$apiKey");
        $httpUrlDao.insert(EkoHttpUrl.create($newHttpUrl));
        $socketUrlDao.insert(EkoSocketUrl.create($newSocketUrl));
        $mqttUrlDao.insert(EkoMqttUrl.create($newMqttUrl));
        $apiKeyDao.insert(EkoApiKey.create($apiKey));
        AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
    }

    private static final CompletableSource setup$lambda-3(Pair it) {
        return (CompletableSource)Completable.complete();
    }

    static {
        sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        appEventBus = new AppEventBus();
        sessionStateEventBus = new SessionStateEventBus();
        AppEventBus appEventBus = AmityCoreClient.appEventBus;
        SessionStateEventBus sessionStateEventBus = AmityCoreClient.sessionStateEventBus;
        SessionLifeCycleEventBus sessionLifeCycleEventBus = AmityCoreClient.sessionLifeCycleEventBus;
        sessionStateManager = new SessionStateManager(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
    }
}

