/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoReactionDao
extends EkoObjectDao<EkoReactionEntity> {
    @Override
    @Delete
    public abstract void delete(EkoReactionEntity var1);

    @Override
    @Query(value="DELETE from reaction")
    public abstract void deleteAll();

    @Query(value="DELETE from reaction where referenceType = :referenceType and referenceId = :referenceId and userId = :userId and reactionName = :reactionName")
    abstract void deleteByPrimaryKeyImpl(String var1, String var2, String var3, String var4);

    public void deleteByPrimaryKey(String referenceType, String referenceId, String userId, String reactionName) {
        this.deleteByPrimaryKeyImpl(referenceType, referenceId, userId, reactionName);
    }

    @Query(value="DELETE from reaction where referenceId = :referenceId and userId = :userId and referenceType = :referenceType")
    abstract void deleteByReferenceIdAndUserIdImpl(String var1, String var2, String var3);

    public void deleteByReferenceIdAndUserId(String referenceId, String referenceType, String userId) {
        this.deleteByReferenceIdAndUserIdImpl(referenceId, referenceType, userId);
    }

    @Query(value="DELETE from reaction where referenceId = :referenceId and referenceType = :referenceType")
    abstract void deleteByReferenceIdImpl(String var1, String var2);

    public void deleteByReferenceId(String referenceId, String referenceType) {
        this.deleteByReferenceIdImpl(referenceId, referenceType);
    }

    @Query(value="SELECT * from reaction where reaction.referenceType = :referenceType and reaction.referenceId = :referenceId and reaction.userId = :userId and reaction.reactionName = :reactionName LIMIT 1")
    abstract Maybe<EkoReactionEntity> getReactionByReferenceAndReactionNameImpl(String var1, String var2, String var3, String var4);

    public Maybe<EkoReactionEntity> getReactionByReferenceAndReactionName(String referenceType, String referenceId, String reactionName, String userId) {
        return this.getReactionByReferenceAndReactionNameImpl(referenceType, referenceId, reactionName, userId);
    }

    @Query(value="SELECT * from reaction where reaction.referenceType = :referenceType and reaction.referenceId = :referenceId and reaction.userId = :userId")
    abstract List<EkoReactionEntity> getAllMyReactionsByReferenceTypeAndReferenceIdNowImpl(String var1, String var2, String var3);

    public List<EkoReactionEntity> getAllMyReactionsByReferenceTypeAndReferenceIdNow(String referenceType, String referenceId) {
        return this.getAllMyReactionsByReferenceTypeAndReferenceIdNowImpl(referenceType, referenceId, AmityCoreClient.INSTANCE.getUserId());
    }

    @Query(value="SELECT * from reaction where reaction.referenceId = :referenceId and reaction.referenceType = :referenceType order by reaction.createdAt DESC")
    public abstract List<EkoReactionEntity> getAllByReferenceTypeAndReferenceId(String var1, String var2);

    @Query(value="SELECT * from reaction where reaction.reactionId >= :reactionId order by reaction.createdAt DESC")
    public abstract List<EkoReactionEntity> getAllAfterReactionId(String var1);

    @Query(value="SELECT * from reaction where reaction.reactionId < :reactionId order by reaction.createdAt DESC")
    public abstract List<EkoReactionEntity> getAllBeforeReactionId(String var1);

    @Query(value="SELECT * from reaction where reaction.reactionId BETWEEN :fromReactionId and :tillReactionId and reaction.reactionId != :tillReactionId order by reaction.createdAt DESC")
    public abstract List<EkoReactionEntity> getAllBetweenReactionId(String var1, String var2);

    @Query(value="SELECT * from reaction where reaction.referenceId = :referenceId and reaction.referenceType = :referenceType and reaction.createdAt > :now order by reaction.createdAt DESC limit 1")
    public abstract Flowable<EkoReactionEntity> getLatestReactionWithoutReactionNameImpl(String var1, String var2, DateTime var3);

    @Query(value="SELECT * from reaction where reaction.referenceId = :referenceId and reaction.referenceType = :referenceType and reaction.reactionName = :reactionName and reaction.createdAt > :now order by reaction.createdAt DESC limit 1")
    public abstract Flowable<EkoReactionEntity> getLatestReactionImpl(String var1, String var2, String var3, DateTime var4);

    public Flowable<EkoReactionEntity> getLatestReaction(String referenceType, String referenceId, @Nullable String reactionName, DateTime now) {
        if (reactionName == null || reactionName.isEmpty()) {
            return this.getLatestReactionWithoutReactionNameImpl(referenceType, referenceId, now);
        }
        return this.getLatestReactionImpl(referenceType, referenceId, reactionName, now);
    }
}

