/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoPostListPersister;", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectPersister;", "()V", "persist", "", "dtoList", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostDto;", "amity-sdk_release"})
public final class EkoPostListPersister
extends EkoObjectPersister {
    @NotNull
    public static final EkoPostListPersister INSTANCE;

    @JvmStatic
    public static final void persist(@NotNull List<? extends EkoPostDto> dtoList) {
        Intrinsics.checkNotNullParameter(dtoList, (String)"dtoList");
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(new Runnable(dtoList, userDatabase){
            final /* synthetic */ List $dtoList;
            final /* synthetic */ UserDatabase $userDatabase;

            public final void run() {
                EkoObjectPersister.persistChanges(this.$dtoList, EkoPostMapper.MAPPER, this.$userDatabase.postDao());
                for (EkoPostDto postDto : this.$dtoList) {
                    if (postDto.getMyReactions() != null) {
                        EkoReactionDao reactionDao = this.$userDatabase.reactionDao();
                        reactionDao.deleteByReferenceIdAndUserId(postDto.getPostId(), ReactionReferenceType.POST.getValue(), AmityCoreClient.INSTANCE.getUserId());
                        ImmutableList immutableList = FluentIterable.from((Iterable)postDto.getMyReactions()).transform((Function)new Function<String, EkoReactionEntity>(postDto){
                            final /* synthetic */ EkoPostDto $postDto;

                            @Nullable
                            public final EkoReactionEntity apply(@Nullable String reactionName) {
                                ReactionRepository reactionRepository = new ReactionRepository();
                                String string = this.$postDto.getPostId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"postDto.postId");
                                String string2 = reactionName;
                                if (string2 == null) {
                                    string2 = "";
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"reactionName ?: \"\"");
                                return reactionRepository.createMyReaction(ReactionReferenceType.POST, string, string2);
                            }
                            {
                                this.$postDto = ekoPostDto;
                            }
                        }).toList();
                        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"FluentIterable.from(post\u2026 ?: \"\")\n\t\t\t\t\t\t\t}.toList()");
                        reactionDao.insert((List)immutableList);
                    }
                    EkoPostFlagDao flagDao = this.$userDatabase.postFlagDao();
                    String string = postDto.getPostId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"postDto.postId");
                    EkoPostFlag postFlag = new EkoPostFlag(string, null, null, 6, null);
                    postFlag.setFlag(postDto.getFlag());
                    EkoPostFlag diskFlag = flagDao.getByIdNow(postDto.getPostId());
                    if (diskFlag != null) {
                        postFlag.setLocalFlag(diskFlag.getLocalFlag());
                        flagDao.update((EkoObject)postFlag);
                        continue;
                    }
                    flagDao.insert((EkoObject)postFlag);
                }
            }
            {
                this.$dtoList = list2;
                this.$userDatabase = userDatabase;
            }
        });
    }

    private EkoPostListPersister() {
    }

    static {
        EkoPostListPersister ekoPostListPersister;
        INSTANCE = ekoPostListPersister = new EkoPostListPersister();
    }
}

