/*
 * Decompiled with CFR 0.152.
 */
package co.amity.rxremotemediator;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import co.amity.rxremotemediator.AmityPagingId;
import co.amity.rxremotemediator.AmityQueryToken;
import co.amity.rxremotemediator.AmityQueryTokenDao;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public final class AmityQueryTokenDao_Impl
implements AmityQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AmityQueryToken> __insertionAdapterOfAmityQueryToken;
    private final EntityInsertionAdapter<AmityPagingId> __insertionAdapterOfAmityPagingId;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAfterPosition;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAfterPageNumber;

    public AmityQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAmityQueryToken = new EntityInsertionAdapter<AmityQueryToken>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `amity_query_token` (`next`,`previous`,`pageNumber`,`hash`,`nonce`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AmityQueryToken value) {
                if (value.getNext() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getNext());
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPrevious());
                }
                stmt.bindLong(3, (long)value.getPageNumber());
                stmt.bindLong(4, (long)value.getHash());
                stmt.bindLong(5, (long)value.getNonce());
            }
        };
        this.__insertionAdapterOfAmityPagingId = new EntityInsertionAdapter<AmityPagingId>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `amity_paging_id` (`id`,`hash`,`nonce`,`position`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AmityPagingId value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                stmt.bindLong(2, (long)value.getHash());
                stmt.bindLong(3, (long)value.getNonce());
                stmt.bindLong(4, (long)value.getPosition());
            }
        };
        this.__preparedStmtOfDeleteAfterPosition = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from amity_paging_id where position > ? and hash = ? and nonce = ?";
                return "delete from amity_paging_id where position > ? and hash = ? and nonce = ?";
            }
        };
        this.__preparedStmtOfDeleteAfterPageNumber = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from amity_query_token where pageNumber > ? and hash = ? and nonce = ?";
                return "delete from amity_query_token where pageNumber > ? and hash = ? and nonce = ?";
            }
        };
    }

    public Completable insertToken(final AmityQueryToken token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmityQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    AmityQueryTokenDao_Impl.this.__insertionAdapterOfAmityQueryToken.insert((Object)token);
                    AmityQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AmityQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    public Completable insertPagingIds(final List<AmityPagingId> pagingIds) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmityQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    AmityQueryTokenDao_Impl.this.__insertionAdapterOfAmityPagingId.insert((Iterable)pagingIds);
                    AmityQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AmityQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    public Completable deleteAfterPosition(final int position, final int hash, final int nonce) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = AmityQueryTokenDao_Impl.this.__preparedStmtOfDeleteAfterPosition.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)position);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)nonce);
                AmityQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AmityQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AmityQueryTokenDao_Impl.this.__db.endTransaction();
                    AmityQueryTokenDao_Impl.this.__preparedStmtOfDeleteAfterPosition.release(_stmt);
                }
            }
        });
    }

    public Completable deleteAfterPageNumber(final int pageNumber, final int hash, final int nonce) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = AmityQueryTokenDao_Impl.this.__preparedStmtOfDeleteAfterPageNumber.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)pageNumber);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)nonce);
                AmityQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AmityQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AmityQueryTokenDao_Impl.this.__db.endTransaction();
                    AmityQueryTokenDao_Impl.this.__preparedStmtOfDeleteAfterPageNumber.release(_stmt);
                }
            }
        });
    }

    public Maybe<AmityQueryToken> getFirstQueryToken(int hash, int nonce) {
        String _sql = "select * from amity_query_token where hash = ? and nonce = ? order by pageNumber asc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from amity_query_token where hash = ? and nonce = ? order by pageNumber asc limit 1", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)nonce);
        return Maybe.fromCallable((Callable)new Callable<AmityQueryToken>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AmityQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AmityQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AmityQueryToken _result;
                    int _cursorIndexOfNext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next");
                    int _cursorIndexOfPrevious = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"previous");
                    int _cursorIndexOfPageNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pageNumber");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfNonce = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nonce");
                    if (_cursor.moveToFirst()) {
                        _result = new AmityQueryToken();
                        String _tmpNext = _cursor.isNull(_cursorIndexOfNext) ? null : _cursor.getString(_cursorIndexOfNext);
                        _result.setNext(_tmpNext);
                        String _tmpPrevious = _cursor.isNull(_cursorIndexOfPrevious) ? null : _cursor.getString(_cursorIndexOfPrevious);
                        _result.setPrevious(_tmpPrevious);
                        int _tmpPageNumber = _cursor.getInt(_cursorIndexOfPageNumber);
                        _result.setPageNumber(_tmpPageNumber);
                        int _tmpHash = _cursor.getInt(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        int _tmpNonce = _cursor.getInt(_cursorIndexOfNonce);
                        _result.setNonce(_tmpNonce);
                    } else {
                        _result = null;
                    }
                    AmityQueryToken amityQueryToken = _result;
                    return amityQueryToken;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Maybe<AmityQueryToken> getLastQueryToken(int hash, int nonce) {
        String _sql = "select * from amity_query_token where hash = ? and nonce = ? order by pageNumber desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from amity_query_token where hash = ? and nonce = ? order by pageNumber desc limit 1", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)nonce);
        return Maybe.fromCallable((Callable)new Callable<AmityQueryToken>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AmityQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AmityQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AmityQueryToken _result;
                    int _cursorIndexOfNext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next");
                    int _cursorIndexOfPrevious = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"previous");
                    int _cursorIndexOfPageNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pageNumber");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfNonce = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nonce");
                    if (_cursor.moveToFirst()) {
                        _result = new AmityQueryToken();
                        String _tmpNext = _cursor.isNull(_cursorIndexOfNext) ? null : _cursor.getString(_cursorIndexOfNext);
                        _result.setNext(_tmpNext);
                        String _tmpPrevious = _cursor.isNull(_cursorIndexOfPrevious) ? null : _cursor.getString(_cursorIndexOfPrevious);
                        _result.setPrevious(_tmpPrevious);
                        int _tmpPageNumber = _cursor.getInt(_cursorIndexOfPageNumber);
                        _result.setPageNumber(_tmpPageNumber);
                        int _tmpHash = _cursor.getInt(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        int _tmpNonce = _cursor.getInt(_cursorIndexOfNonce);
                        _result.setNonce(_tmpNonce);
                    } else {
                        _result = null;
                    }
                    AmityQueryToken amityQueryToken = _result;
                    return amityQueryToken;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Maybe<AmityQueryToken> getTokenByPageNumber(int pageNumber, int hash, int nonce) {
        String _sql = "select * from amity_query_token where pageNumber = ? and hash = ? and nonce = ? limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from amity_query_token where pageNumber = ? and hash = ? and nonce = ? limit 1", (int)3);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)pageNumber);
        _argIndex = 2;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 3;
        _statement.bindLong(_argIndex, (long)nonce);
        return Maybe.fromCallable((Callable)new Callable<AmityQueryToken>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AmityQueryToken call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AmityQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AmityQueryToken _result;
                    int _cursorIndexOfNext = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"next");
                    int _cursorIndexOfPrevious = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"previous");
                    int _cursorIndexOfPageNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pageNumber");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfNonce = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"nonce");
                    if (_cursor.moveToFirst()) {
                        _result = new AmityQueryToken();
                        String _tmpNext = _cursor.isNull(_cursorIndexOfNext) ? null : _cursor.getString(_cursorIndexOfNext);
                        _result.setNext(_tmpNext);
                        String _tmpPrevious = _cursor.isNull(_cursorIndexOfPrevious) ? null : _cursor.getString(_cursorIndexOfPrevious);
                        _result.setPrevious(_tmpPrevious);
                        int _tmpPageNumber = _cursor.getInt(_cursorIndexOfPageNumber);
                        _result.setPageNumber(_tmpPageNumber);
                        int _tmpHash = _cursor.getInt(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        int _tmpNonce = _cursor.getInt(_cursorIndexOfNonce);
                        _result.setNonce(_tmpNonce);
                    } else {
                        _result = null;
                    }
                    AmityQueryToken amityQueryToken = _result;
                    return amityQueryToken;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Completable deleteAfterPosition(int position, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.deleteAfterPosition((AmityQueryTokenDao)this, (int)position, queryParameters, (int)nonce);
    }

    public Completable deleteAfterPageNumber(int pageNumber, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.deleteAfterPageNumber((AmityQueryTokenDao)this, (int)pageNumber, queryParameters, (int)nonce);
    }

    public Maybe<AmityQueryToken> getFirstQueryToken(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getFirstQueryToken((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Maybe<AmityQueryToken> getLastQueryToken(Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getLastQueryToken((AmityQueryTokenDao)this, queryParameters, (int)nonce);
    }

    public Maybe<String> getTokenByPageNumber(int pageNumber, Map<String, ?> queryParameters, int nonce) {
        return AmityQueryTokenDao.DefaultImpls.getTokenByPageNumber((AmityQueryTokenDao)this, (int)pageNumber, queryParameters, (int)nonce);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

