/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import java.util.List;

class EkoMyCommunityMembershipPersister {
    EkoMyCommunityMembershipPersister() {
    }

    static void persist(List<EkoCommunityDto> communityDtoList) {
        EkoCommunityMembershipDao membershipDao = UserDatabase.get().communityMembershipDao();
        for (EkoCommunityDto communityDto : communityDtoList) {
            boolean hasMembershipInfo = membershipDao.getByCommunityIdAndUserIdNow(communityDto.getCommunityId(), AmityCoreClient.INSTANCE.getUserId()) != null;
            if (hasMembershipInfo) continue;
            CommunityMembershipEntity defaultMembership = new CommunityMembershipEntity();
            defaultMembership.setCommunityId(communityDto.getCommunityId());
            defaultMembership.setUserId(AmityCoreClient.INSTANCE.getUserId());
            defaultMembership.setRoles(new AmityRoles());
            defaultMembership.setPermissions(new AmityPermissions());
            membershipDao.insert(defaultMembership);
        }
    }
}

