/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.core.utils.validation;

import arrow.core.Either;
import arrow.core.EitherKt;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.ekoapp.core.utils.validation.EkoErrorData;
import com.ekoapp.core.utils.validation.ExceptionCreatorKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J/\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0002\u00a2\u0006\u0002\u0010\rJ/\u0010\u000e\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0002\u00a2\u0006\u0002\u0010\rJ/\u0010\u000f\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0002\u00a2\u0006\u0002\u0010\rJ+\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u0011\"\u0006\b\u0000\u0010\t\u0018\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\t0\u0013H\u0086\bJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"Lcom/ekoapp/core/utils/validation/EkoValidator;", "", "()V", "getErrorData", "Lcom/ekoapp/core/utils/validation/EkoErrorData;", "t", "", "handleLong", "", "T", "v", "cb", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "handleObject", "handleString", "params", "Larrow/core/Either;", "l", "", "throwDevMessage", "throwUserMessage", "amity-sdk_release"})
public final class EkoValidator {
    @NotNull
    public final Throwable throwUserMessage(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new Throwable(this.getErrorData(t).getUserMessage());
    }

    @NotNull
    public final Throwable throwDevMessage(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new Throwable(this.getErrorData(t).getDevMessage());
    }

    private final EkoErrorData getErrorData(Throwable t) {
        AmityError error = AmityError.Companion.from(t);
        AmityException exception = AmityException.Companion.create(t.getLocalizedMessage(), new Throwable(error.name()), error.getCode());
        Throwable throwable = exception.getCause();
        return new EkoErrorData(exception.getLocalizedMessage(), String.valueOf(throwable != null ? throwable.getMessage() : null), error.getCode());
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> Either<Throwable, Unit> params(List<? extends T> l) {
        void result;
        int $i$f$params = 0;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = EitherKt.Right((Object)Unit.INSTANCE);
        Iterable $this$forEach$iv = l;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object v = element$iv = iterator.next();
            boolean bl = false;
            Object t = v;
            if (t instanceof String) {
                this.handleString(v, (Function1<? super EkoErrorData, Unit>)((Function1)new Function1<EkoErrorData, Unit>(this, (Ref.ObjectRef)result){
                    final /* synthetic */ EkoValidator this$0;
                    final /* synthetic */ Ref.ObjectRef $result$inlined;
                    {
                        this.this$0 = ekoValidator;
                        this.$result$inlined = objectRef;
                        super(1);
                    }

                    public final void invoke(@NotNull EkoErrorData it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$result$inlined.element = EitherKt.Left((Object)new Throwable(it.getUserMessage()));
                    }
                }));
                continue;
            }
            if (t instanceof Long) {
                this.handleLong(v, (Function1<? super EkoErrorData, Unit>)((Function1)new Function1<EkoErrorData, Unit>(this, (Ref.ObjectRef)result){
                    final /* synthetic */ EkoValidator this$0;
                    final /* synthetic */ Ref.ObjectRef $result$inlined;
                    {
                        this.this$0 = ekoValidator;
                        this.$result$inlined = objectRef;
                        super(1);
                    }

                    public final void invoke(@NotNull EkoErrorData it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$result$inlined.element = EitherKt.Left((Object)new Throwable(it.getUserMessage()));
                    }
                }));
                continue;
            }
            this.handleObject(v, (Function1<? super EkoErrorData, Unit>)((Function1)new Function1<EkoErrorData, Unit>(this, (Ref.ObjectRef)result){
                final /* synthetic */ EkoValidator this$0;
                final /* synthetic */ Ref.ObjectRef $result$inlined;
                {
                    this.this$0 = ekoValidator;
                    this.$result$inlined = objectRef;
                    super(1);
                }

                public final void invoke(@NotNull EkoErrorData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$result$inlined.element = EitherKt.Left((Object)new Throwable(it.getUserMessage()));
                }
            }));
        }
        return (Either)result.element;
    }

    private final <T> void handleString(T v, Function1<? super EkoErrorData, Unit> cb) {
        if (v == null) {
            cb.invoke((Object)this.getErrorData(ExceptionCreatorKt.getNullPointerException()));
        } else if (v instanceof String) {
            CharSequence charSequence = (CharSequence)v;
            boolean bl = false;
            if (charSequence.length() == 0) {
                cb.invoke((Object)this.getErrorData(ExceptionCreatorKt.getEmptyException()));
            }
        }
    }

    private final <T> void handleLong(T v, Function1<? super EkoErrorData, Unit> cb) {
        long fileSizeLimitInBytes = 0x40000000L;
        if (v == null) {
            cb.invoke((Object)this.getErrorData(ExceptionCreatorKt.getNullPointerException()));
        } else if (v instanceof Long && (((Number)v).longValue() > fileSizeLimitInBytes || ((Number)v).longValue() < 0L)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s File size exceeded!";
            Object[] objectArray = new Object[]{v};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String msg = string2;
            AmityException fileSizeException = AmityException.Companion.create(msg, null, AmityError.FILE_SIZE_EXCEEDED);
            cb.invoke((Object)this.getErrorData(fileSizeException));
        }
    }

    private final <T> void handleObject(T v, Function1<? super EkoErrorData, Unit> cb) {
        if (v == null) {
            cb.invoke((Object)this.getErrorData(ExceptionCreatorKt.getNullPointerException()));
        } else if (v instanceof List && ((List)v).isEmpty()) {
            cb.invoke((Object)this.getErrorData(ExceptionCreatorKt.getEmptyException()));
        }
    }
}

