/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.authen.DeviceRegistration;
import com.amity.socialcloud.sdk.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserNotification;
import com.amity.socialcloud.sdk.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.core.user.AmityUserUpdate;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.ekoapp.ekosdk.StreamFunction;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0004J\u001e\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u0006\u0010-\u001a\u00020(J\u0006\u0010.\u001a\u00020(J\u000e\u0010.\u001a\u00020(2\u0006\u0010&\u001a\u00020\u0004J\u0006\u0010/\u001a\u000200R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u00061"}, d2={"Lcom/amity/socialcloud/sdk/AmityCoreClient;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getConnectionState", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/AmityConnectionState;", "getCurrentUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/core/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermission;", "newFileRepository", "Lcom/amity/socialcloud/sdk/core/file/AmityFileRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/core/user/AmityUserNotification;", "registerDevice", "Lcom/amity/socialcloud/sdk/core/authen/DeviceRegistration$Builder;", "userId", "registerDeviceForPushNotification", "Lio/reactivex/Completable;", "setup", "apiKey", "httpEndpoint", "socketEndpoint", "unregisterDevice", "unregisterDeviceForPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class AmityCoreClient {
    private static final String TAG;
    private static int millisTimeDiff;
    @NotNull
    public static final AmityCoreClient INSTANCE;

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"DateTime.now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull String httpEndpoint, @NotNull String socketEndpoint) {
        EkoApiKeyDao apiKeyDao;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)httpEndpoint, (String)"httpEndpoint");
        Intrinsics.checkNotNullParameter((Object)socketEndpoint, (String)"socketEndpoint");
        if (!EkoSdkInitProvider.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"CompletableSubject.create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        String string = httpEndpoint;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string2 = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
        if (string2 == null) {
            string2 = "https://api.amity.co/";
        }
        String newHttpUrl = string2;
        String string3 = socketEndpoint;
        bl2 = false;
        boolean bl5 = false;
        String it2 = string3;
        boolean bl6 = false;
        CharSequence charSequence2 = it2;
        boolean bl7 = false;
        String string4 = !StringsKt.isBlank((CharSequence)charSequence2) ? string3 : null;
        if (string4 == null) {
            string4 = "https://api.amity.co/";
        }
        String newSocketUrl = string4;
        EkoApiKeyDao ekoApiKeyDao = apiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoApiKeyDao, (String)"apiKeyDao");
        MaybeSource maybeSource = (MaybeSource)ekoApiKeyDao.getCurrentApiKey();
        EkoHttpUrlDao ekoHttpUrlDao = httpUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoHttpUrlDao, (String)"httpUrlDao");
        MaybeSource maybeSource2 = (MaybeSource)ekoHttpUrlDao.getCurrentHttpUrl();
        EkoSocketUrlDao ekoSocketUrlDao = socketUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoSocketUrlDao, (String)"socketUrlDao");
        Maybe.zip((MaybeSource)maybeSource, (MaybeSource)maybeSource2, (MaybeSource)((MaybeSource)ekoSocketUrlDao.getCurrentSocketUrl()), (Function3)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<Triple<? extends EkoApiKey, ? extends EkoHttpUrl, ? extends EkoSocketUrl>>(newHttpUrl, apiKey, newSocketUrl, httpUrlDao, socketUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;

            public final void accept(@NotNull Triple<? extends EkoApiKey, ? extends EkoHttpUrl, ? extends EkoSocketUrl> setupTriplets) {
                Intrinsics.checkNotNullParameter(setupTriplets, (String)"setupTriplets");
                String string = ((EkoApiKey)setupTriplets.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupTriplets.first.apiKey");
                String storedApiKey = string;
                String string2 = ((EkoHttpUrl)setupTriplets.getSecond()).getHttpUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"setupTriplets.second.httpUrl");
                String storedHttpUrl = string2;
                String string3 = ((EkoSocketUrl)setupTriplets.getThird()).getSocketUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"setupTriplets.third.socketUrl");
                String storedSocketUrl = string3;
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)storedSocketUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey))) {
                    Timber.tag((String)AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE)).e("Setup value changed. new api key: %s new http url: %s new socket url: %s", new Object[]{this.$apiKey, this.$newHttpUrl, this.$newSocketUrl});
                    Timber.tag((String)AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE)).e("deleting user database", new Object[0]);
                    AmityCoreClient.INSTANCE.unregisterDevice();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$newHttpUrl = string;
                this.$apiKey = string2;
                this.$newSocketUrl = string3;
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$apiKeyDao = ekoApiKeyDao;
            }
        }).doOnComplete(new Action(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, apiKeyDao, apiKey){
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            final /* synthetic */ String $apiKey;

            public final void run() {
                this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$newHttpUrl = string;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$newSocketUrl = string2;
                this.$apiKeyDao = ekoApiKeyDao;
                this.$apiKey = string3;
            }
        }).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, "", "");
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        EkoAccountDao ekoAccountDao = EkoDatabase.get().accountDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoAccountDao, (String)"EkoDatabase.get()\n                .accountDao()");
        Completable completable = ekoAccountDao.getCurrentAccountSingle().flatMapCompletable((Function)registerDeviceForPushNotification.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoDatabase.get()\n      \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        Completable completable = Completable.fromAction((Action)unregisterDeviceForPushNotification.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        EkoPreconditions.checkValidId(userId, "userId");
        Completable completable = EkoDatabase.get().accountDao().getByIdMaybe(userId).switchIfEmpty((MaybeSource)Maybe.never()).flatMapCompletable((Function)unregisterDeviceForPushNotification.2.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoDatabase.get()\n      \u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final DeviceRegistration.Builder registerDevice(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new DeviceRegistration.Builder(userId);
    }

    @NotNull
    public final Completable unregisterDevice() {
        Completable completable = Completable.fromAction((Action)unregisterDevice.1.INSTANCE).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026scribeOn(Schedulers.io())");
        return completable;
    }

    @NotNull
    public final String getUserId() {
        Object object = EkoAccountCache.getMyUserId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EkoAccountCache.getMyUserId().get()");
        return (String)object;
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "5.8.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        Flowable<AmityGlobalBanEvent> flowable = EkoSocket.getGlobalBanEvents();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"EkoSocket.getGlobalBanEvents()");
        return flowable;
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @NotNull
    public final Flowable<AmityConnectionState> getConnectionState() {
        Flowable<AmityConnectionState> flowable = EkoSocket.getConnectionState();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"EkoSocket.getConnectionState()");
        return flowable;
    }

    private AmityCoreClient() {
    }

    static {
        AmityCoreClient amityCoreClient;
        INSTANCE = amityCoreClient = new AmityCoreClient();
        TAG = AmityCoreClient.class.getName();
    }

    public static final /* synthetic */ String access$getTAG$p(AmityCoreClient $this) {
        AmityCoreClient amityCoreClient = $this;
        return TAG;
    }
}

