/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.data.dao.PostDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;

public class CommentDeleteConverter
implements ResponseConverter<EkoDeletionDto> {
    private final String commentId;

    public CommentDeleteConverter(String commentId) {
        this.commentId = commentId;
    }

    @Override
    public EkoDeletionDto convert(SocketResponse response) {
        UserDatabase database;
        EkoCommentDao commentDao;
        CommentEntity commentEntity;
        EkoDeletionDto dto = (EkoDeletionDto)response.getData(EkoDeletionDto.class);
        if (dto.isSuccess() && (commentEntity = (commentDao = (database = UserDatabase.get()).commentDao()).getByIdNow(this.commentId)) != null) {
            commentDao.deleteCommentByCommentId(this.commentId);
            switch (commentEntity.getReferenceType()) {
                case "post": {
                    PostDao postDao = database.postDao();
                    postDao.decrementCommentCount(commentEntity.getReferenceId());
                    break;
                }
            }
        }
        return dto;
    }
}

