/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategory;
import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityCategoryBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityCategoryRepositoryHelper;
import io.reactivex.Flowable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityCategoryRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "getAllCategories", "Lio/reactivex/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategory;", "sortOption", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategorySortOption;", "isDeleted", "", "(Lcom/amity/socialcloud/sdk/social/community/AmityCommunityCategorySortOption;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "getDefaultPageSize", "", "amity-sdk_release"})
public final class CommunityCategoryRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunityCategory>> getAllCategories(@NotNull AmityCommunityCategorySortOption sortOption, @Nullable Boolean isDeleted) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortOption), (String)"sortOption");
        EkoCommunityCategoryDao communityCategory = UserDatabase.get().communityCategoryDao();
        DataSource.Factory<Integer, CommunityCategoryEntity> localFactory = communityCategory.getAll(sortOption, isDeleted);
        DataSource.Factory factory2 = localFactory.map(CommunityCategoryRepositoryHelper.INSTANCE.getFactoryMapper());
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoCommunityCategoryBoundaryCallback boundaryCallback = new EkoCommunityCategoryBoundaryCallback(sortOption, isDeleted, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((Function)boundaryCallback), boundaryCallback);
    }
}

