/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.CommunityFeedQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.CommunityFeedQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class CommunityFeedQueryTokenDao_Impl
extends CommunityFeedQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityFeedQueryTokenEntity> __insertionAdapterOfCommunityFeedQueryTokenEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public CommunityFeedQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityFeedQueryTokenEntity = new EntityInsertionAdapter<CommunityFeedQueryTokenEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_feed_query_token` (`communityId`,`sortBy`,`feedType`,`isDeleted`,`postTypes`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityFeedQueryTokenEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getSortBy() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSortBy());
                }
                if (value.getFeedType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFeedType());
                }
                if (value.isDeleted() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.isDeleted());
                }
                if (value.getPostTypes() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPostTypes());
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getNext());
                }
                stmt.bindLong(8, (long)value.getPageNumber());
                String _tmp = CommunityFeedQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp);
                }
                String _tmp_1 = CommunityFeedQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_1);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final CommunityFeedQueryTokenEntity token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CommunityFeedQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    CommunityFeedQueryTokenDao_Impl.this.__insertionAdapterOfCommunityFeedQueryTokenEntity.insert((Object)token);
                    CommunityFeedQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    CommunityFeedQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<CommunityFeedQueryTokenEntity> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<CommunityFeedQueryTokenEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityFeedQueryTokenEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CommunityFeedQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    CommunityFeedQueryTokenEntity _result = _cursor.moveToFirst() ? CommunityFeedQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelCommunityFeedQueryTokenEntity(_cursor) : null;
                    CommunityFeedQueryTokenEntity communityFeedQueryTokenEntity = _result;
                    return communityFeedQueryTokenEntity;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private CommunityFeedQueryTokenEntity __entityCursorConverter_comEkoappEkosdkInternalDataModelCommunityFeedQueryTokenEntity(Cursor cursor) {
        int _cursorIndexOfCommunityId = cursor.getColumnIndex("communityId");
        int _cursorIndexOfSortBy = cursor.getColumnIndex("sortBy");
        int _cursorIndexOfFeedType = cursor.getColumnIndex("feedType");
        int _cursorIndexOfIsDeleted = cursor.getColumnIndex("isDeleted");
        int _cursorIndexOfPostTypes = cursor.getColumnIndex("postTypes");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        String _tmpCommunityId = _cursorIndexOfCommunityId == -1 ? null : (cursor.isNull(_cursorIndexOfCommunityId) ? null : cursor.getString(_cursorIndexOfCommunityId));
        String _tmpSortBy = _cursorIndexOfSortBy == -1 ? null : (cursor.isNull(_cursorIndexOfSortBy) ? null : cursor.getString(_cursorIndexOfSortBy));
        String _tmpFeedType = _cursorIndexOfFeedType == -1 ? null : (cursor.isNull(_cursorIndexOfFeedType) ? null : cursor.getString(_cursorIndexOfFeedType));
        String _tmpIsDeleted = _cursorIndexOfIsDeleted == -1 ? null : (cursor.isNull(_cursorIndexOfIsDeleted) ? null : cursor.getString(_cursorIndexOfIsDeleted));
        String _tmpPostTypes = _cursorIndexOfPostTypes == -1 ? null : (cursor.isNull(_cursorIndexOfPostTypes) ? null : cursor.getString(_cursorIndexOfPostTypes));
        CommunityFeedQueryTokenEntity _entity = new CommunityFeedQueryTokenEntity(_tmpCommunityId, _tmpSortBy, _tmpFeedType, _tmpIsDeleted, _tmpPostTypes);
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

