/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.event.MessageListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.message.mention.AmityMessageMentionType;
import com.google.common.base.Objects;

public class MessageDidCreateListener
extends MessageListener {
    @Override
    @NonNull
    public String getEvent() {
        return "v3.message.didCreate";
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        EkoMessageAndUserListDto messageAndUserDto = (EkoMessageAndUserListDto)EkoGson.get().fromJson(json, EkoMessageAndUserListDto.class);
        EkoMessageDto messageDto = messageAndUserDto.getMessages().get(0);
        EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        EkoChannelExtra extra = extraDao.getByIdNow(messageDto.getChannelId());
        if (Objects.equal((Object)AmityCoreClient.INSTANCE.getUserId(), (Object)messageDto.getUserId()) || extra != null && Objects.equal((Object)((Object)EkoChannelReadStatus.READING), (Object)((Object)extra.getReadStatus()))) {
            membershipDao.updateReadToSegment(messageDto.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), messageDto.getChannelSegment());
        }
        for (EkoMentioneesDto mentioneesDto : messageDto.getMentionees()) {
            boolean isMentionChannel;
            boolean bl = isMentionChannel = AmityMessageMentionType.Companion.enumOf(mentioneesDto.getType()) == AmityMessageMentionType.CHANNEL;
            if (!isMentionChannel && (mentioneesDto.getUserIds() == null || !mentioneesDto.getUserIds().contains(AmityCoreClient.INSTANCE.getUserId()))) continue;
            membershipDao.updateLastMentionedSegment(messageDto.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), messageDto.getChannelSegment());
        }
        EkoChannelDao channelDao = UserDatabase.get().channelDao();
        channelDao.updateMessageCount(messageDto.getChannelId(), messageDto.getChannelSegment());
    }
}

