/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoFollowQueryMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.FollowQueryToken;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/api/socket/call/FollowingPagingQueryConverter;", "Lcom/ekoapp/ekosdk/internal/api/socket/call/ResponseConverter;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoFollowQueryDto;", "keys", "", "", "", "(Ljava/util/Map;)V", "convert", "response", "Lcom/amity/socialcloud/sdk/socket/model/SocketResponse;", "invalidateCache", "", "dto", "amity-sdk_release"})
public final class FollowingPagingQueryConverter
implements ResponseConverter<EkoFollowQueryDto> {
    private final Map<String, Object> keys;

    @Override
    @NotNull
    public EkoFollowQueryDto convert(@NotNull SocketResponse response) {
        EkoFollowQueryDto dto;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        EkoFollowQueryDto ekoFollowQueryDto = dto = (EkoFollowQueryDto)response.getData(EkoFollowQueryDto.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoFollowQueryDto, (String)"dto");
        this.invalidateCache(ekoFollowQueryDto);
        EkoFollowQueryMapper.MAPPER.map(dto);
        return dto;
    }

    private final void invalidateCache(EkoFollowQueryDto dto) {
        FollowQueryToken followQueryToken = dto.getPaging();
        if ((followQueryToken != null ? followQueryToken.getPrevious() : null) == null) {
            UserDatabase.get().followingQueryTokenDao().deleteObsoleteQueryToken(this.keys, 0);
        }
    }

    public FollowingPagingQueryConverter(@NotNull Map<String, ? extends Object> keys) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        this.keys = keys;
    }
}

