/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityWithCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class EkoCommunityDao
extends EkoObjectDao<CommunityEntity> {
    private final EkoCommunityWithCategoryDao communityWithCategoryDao = UserDatabase.get().communityWithCategoryDao();

    @Override
    @Query(value="DELETE from community")
    public abstract void deleteAll();

    @Query(value="UPDATE community set isDeleted = 1 where communityId = :communityId")
    abstract void deleteByCommunityIdImpl(String var1);

    @Transaction
    public void deleteByCommunityId(String communityId) {
        this.deleteByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from community where community.communityId = :communityId LIMIT 1")
    abstract Flowable<CommunityEntity> getByCommunityIdImpl(String var1);

    public Flowable<CommunityEntity> getByCommunityId(String communityId) {
        return this.getByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.communityId in (SELECT communityId from category where categoryId = :categoryId) and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdImpl(String var1, String var2, boolean var3, boolean var4, Boolean var5);

    public DataSource.Factory<Integer, CommunityEntity> getAllByCategoryId(String keyword, String categoryId, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByCategoryIdImpl(keyword, categoryId, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.isJoined = 1 and community.communityId in (SELECT communityId from category where categoryId = :categoryId) and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForMemberImpl(String var1, String var2, boolean var3, boolean var4, Boolean var5);

    public DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForMember(String keyword, String categoryId, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByCategoryIdForMemberImpl(keyword, categoryId, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.isJoined = 0 and community.communityId in (SELECT communityId from category where categoryId = :categoryId) and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForNonMemberImpl(String var1, String var2, boolean var3, boolean var4, Boolean var5);

    public DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForNonMember(String keyword, String categoryId, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByCategoryIdForNonMemberImpl(keyword, categoryId, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByKeywordImpl(String var1, boolean var2, boolean var3, Boolean var4);

    public DataSource.Factory<Integer, CommunityEntity> getAllByKeyword(String keyword, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByKeywordImpl(keyword, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.isJoined = 1 and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForMemberImpl(String var1, boolean var2, boolean var3, Boolean var4);

    public DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForMember(String keyword, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByKeywordForMemberImpl(keyword, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from community where community.displayName LIKE :keyword || '%' COLLATE NOCASE and community.isJoined = 0 and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) order by case when :isSortByDisplayName = 1 then community.displayName end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 1 then community.createdAt end asc, case when :isSortByDisplayName = 0 and :isSortByCreatedACS = 0 then community.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForNonMemberImpl(String var1, boolean var2, boolean var3, Boolean var4);

    public DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForNonMember(String keyword, AmityCommunitySortOption sortBy, Boolean isDeleted) {
        return this.getAllByKeywordForNonMemberImpl(keyword, this.isSortByDisplayName(sortBy), this.isSortByCreatedACS(sortBy), isDeleted).map(input -> input);
    }

    @Query(value="UPDATE community set isJoined = :isJoined where communityId = :communityId")
    abstract void updateIsJoinedImpl(String var1, Boolean var2);

    public void updateIsJoined(String communityId, Boolean isJoined) {
        this.updateIsJoinedImpl(communityId, isJoined);
    }

    private Boolean isSortByDisplayName(AmityCommunitySortOption sortBy) {
        return sortBy == AmityCommunitySortOption.DISPLAY_NAME;
    }

    private Boolean isSortByCreatedACS(AmityCommunitySortOption sortBy) {
        return sortBy == AmityCommunitySortOption.FIRST_CREATED;
    }

    @Override
    @Transaction
    public void insert(CommunityEntity community) {
        super.insert(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void insert(List<CommunityEntity> communities) {
        super.insert(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(CommunityEntity community) {
        super.update(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(List<CommunityEntity> communities) {
        super.update(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Query(value="SELECT * from community where communityId = :id LIMIT 1")
    abstract CommunityEntity getByIdNowImpl(String var1);

    @Override
    public CommunityEntity getByIdNow(String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT * from community where community.communityId IN (:ids)")
    abstract List<CommunityEntity> getByIdsNowImpl(List<String> var1);

    public List<CommunityEntity> getByIdNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Transaction
    @Query(value="SELECT community.*, trending_community.* from community, trending_community where community.communityId = trending_community.communityId order by trending_community.createdAt ASC")
    abstract DataSource.Factory<Integer, CommunityEntity> getTrendingCommunityCollectionImpl();

    public DataSource.Factory<Integer, CommunityEntity> getTrendingCommunityCollection() {
        return this.getTrendingCommunityCollectionImpl();
    }

    @Transaction
    @Query(value="SELECT community.*, recommended_community.* from community, recommended_community where community.communityId = recommended_community.communityId order by recommended_community.createdAt ASC")
    abstract DataSource.Factory<Integer, CommunityEntity> getRecommendedCommunityCollectionImpl();

    public DataSource.Factory<Integer, CommunityEntity> getRecommendedCommunityCollection() {
        return this.getRecommendedCommunityCollectionImpl();
    }
}

