/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.init;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.amity.socialcloud.sdk.log.AmityLog;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTimeZone;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/ekoapp/ekosdk/internal/init/TimeZoneChangedReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "amity-sdk_release"})
public final class TimeZoneChangedReceiver
extends BroadcastReceiver {
    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String tzId = intent.getStringExtra("time-zone");
        try {
            DateTimeZone newDefault = DateTimeZone.forTimeZone((TimeZone)TimeZone.getDefault());
            DateTimeZone.setDefault((DateTimeZone)newDefault);
            String string = TimeZoneChangedReceiver.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TimeZoneChangedReceiver::class.java.name");
            AmityLog.INSTANCE.tag(string).d("TIMEZONE_CHANGED received, changed default timezone to \"" + tzId + '\"', new Object[0]);
        }
        catch (IllegalArgumentException e) {
            String string = TimeZoneChangedReceiver.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TimeZoneChangedReceiver::class.java.name");
            AmityLog.INSTANCE.tag(string).e((Throwable)e, "Could not recognize timezone id \"" + tzId + '\"', new Object[0]);
        }
    }
}

