/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.keycreator;

import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper;
import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.social.feed.AmityPost;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ5\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ekoapp/ekosdk/internal/keycreator/CommunityPostKeyCreator;", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "communityId", "", "sortBy", "isDeleted", "", "feedType", "Lcom/amity/socialcloud/sdk/social/feed/AmityFeedType;", "postTypes", "", "Lcom/amity/socialcloud/sdk/social/feed/AmityPost$DataType;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/social/feed/AmityFeedType;Ljava/util/List;)V", "Ljava/lang/Boolean;", "getConditionStatement", "includeDeleted", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;)Ljava/lang/String;", "getFilterQuery", "getPostTypesAsArrayString", "toMap", "", "", "amity-sdk_release"})
public final class CommunityPostKeyCreator
implements DynamicQueryStreamKeyCreator {
    @NotNull
    private final String communityId;
    @NotNull
    private final String sortBy;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final AmityFeedType feedType;
    @NotNull
    private final List<AmityPost.DataType> postTypes;

    public CommunityPostKeyCreator(@NotNull String communityId, @NotNull String sortBy, @Nullable Boolean isDeleted, @NotNull AmityFeedType feedType, @NotNull List<? extends AmityPost.DataType> postTypes) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        Intrinsics.checkNotNullParameter(postTypes, (String)"postTypes");
        this.communityId = communityId;
        this.sortBy = sortBy;
        this.isDeleted = isDeleted;
        this.feedType = feedType;
        this.postTypes = postTypes;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"targetId", (Object)this.communityId);
        pairArray[1] = TuplesKt.to((Object)"targetType", (Object)AmityPost.TargetType.COMMUNITY.getApiKey());
        pairArray[2] = TuplesKt.to((Object)"sortBy", (Object)this.sortBy);
        Boolean bl = this.isDeleted;
        pairArray[3] = TuplesKt.to((Object)"isDeleted", (Object)(bl != null ? bl : false));
        pairArray[4] = TuplesKt.to((Object)"feedType", (Object)this.feedType.getApiKey());
        pairArray[5] = TuplesKt.to((Object)"postTypes", (Object)PostRepositoryHelper.INSTANCE.convertPostTypesToString(this.postTypes));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public String getFilterQuery() {
        return this.getConditionStatement(this.communityId, this.feedType.getApiKey(), this.isDeleted, this.postTypes);
    }

    private final String getConditionStatement(String communityId, String feedType, Boolean includeDeleted, List<? extends AmityPost.DataType> postTypes) {
        Collection collection;
        String communityFilterStatement = "post.targetType = '" + AmityPost.TargetType.COMMUNITY.getApiKey() + "' and post.targetId = '" + communityId + '\'';
        String feedTypeFilterStatement = " and post.feedType = '" + feedType + '\'';
        String isDeletedFilterStatement = "";
        if (Intrinsics.areEqual((Object)includeDeleted, (Object)false)) {
            isDeletedFilterStatement = " and post.isDeleted = 0";
        } else if (Intrinsics.areEqual((Object)includeDeleted, (Object)true)) {
            isDeletedFilterStatement = " and post.isDeleted = 1";
        }
        String postTypesFilterStatement = "";
        if (!((Collection)postTypes).isEmpty()) {
            postTypesFilterStatement = " and post.postDataType IN (" + this.getPostTypesAsArrayString(postTypes) + ')';
        }
        String parentPostFilter = (collection = (Collection)postTypes) == null || collection.isEmpty() ? " and post.parentPostId is null" : " and post.targetId is not null";
        return communityFilterStatement + feedTypeFilterStatement + isDeletedFilterStatement + postTypesFilterStatement + parentPostFilter;
    }

    /*
     * WARNING - void declaration
     */
    private final String getPostTypesAsArrayString(List<? extends AmityPost.DataType> postTypes) {
        StringBuilder typesString = new StringBuilder();
        Iterable $this$forEachIndexed$iv = postTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void dataType;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AmityPost.DataType dataType2 = (AmityPost.DataType)item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0) {
                typesString.append('\'' + dataType.getApiKey() + '\'');
                continue;
            }
            typesString.append(", '" + dataType.getApiKey() + '\'');
        }
        String string = typesString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typesString.toString()");
        return string;
    }

    @Override
    @Nullable
    public String optionalFilterQuery() {
        return DynamicQueryStreamKeyCreator.DefaultImpls.optionalFilterQuery(this);
    }
}

