/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.amity.socialcloud.sdk.core.user.AmityMembershipType;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmityPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelTagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoTagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoChannelTag;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.joda.time.DateTime;

@Dao
public abstract class EkoChannelDao
extends EkoObjectDao<EkoChannelEntity>
implements AmityPagingDao<EkoChannelWithMembershipAndExtra> {
    private final EkoChannelMembershipDao channelMembershipDao;
    private final EkoMessageDao messageDao;
    private final EkoChannelTagDao channelTagDao;
    private final EkoChannelExtraDao channelExtraDao;

    EkoChannelDao() {
        UserDatabase db = UserDatabase.get();
        this.channelMembershipDao = db.channelMembershipDao();
        this.messageDao = db.messageDao();
        this.channelTagDao = db.channelTagDao();
        this.channelExtraDao = db.channelExtraDao();
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = :membership) and channel_membership.userId = :userId")
    abstract Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannelsImpl(String var1, String var2);

    public Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannels(String userId) {
        return this.getAllJoinedChannelsImpl(userId, AmityMembershipType.MEMBER.getApiKey());
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel_membership.userId = :userId and channel.channelType in (:channelTypes) and case when :isFilterByTags then channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) else channel.channelId is not null end and case when :isFilterByMemberships then channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) else channel.channelId is not null end and channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) and case when :isDeleted is not null then channel.isDeleted = :isDeleted else channel.channelId is not null end order by channel.lastActivity DESC")
    abstract DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getDataSourceImpl(String var1, String[] var2, boolean var3, String[] var4, String[] var5, boolean var6, String[] var7, Boolean var8);

    public DataSource.Factory<Integer, EkoChannelEntity> getDataSource(String userId, String[] channelTypes, AmityTags includingTags, AmityTags excludingTags, List<String> memberships, Boolean isDeleted) {
        return this.getDataSourceImpl(userId, channelTypes, !includingTags.isEmpty(), includingTags.toArray(new String[0]), excludingTags.toArray(new String[0]), !memberships.isEmpty(), memberships.toArray(new String[0]), isDeleted).map(input -> input);
    }

    @Query(value="SELECT * from channel where channel.channelType in (:types) and case when :isFilterByMemberships then channel.channelId in (SELECT channelId from channel_membership where membership in (:memberships) and userId = :userId) else channel.channelId is not null end and case when :isIncludingTags then channel.channelId in (SELECT channelId from channel_tag where tagName in (:includingTags)) else channel.channelId is not null end and case when :isExcludingTags then channel.channelId not in (SELECT channelId from channel_tag where tagName in (:excludingTags)) else channel.channelId is not null end and case when :isDeleted is not null then channel.isDeleted = :isDeleted else channel.channelId is not null end and channel.updatedAt > :now and channel.channelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by channel.updatedAt  desc limit 1")
    abstract Flowable<EkoChannelEntity> getLatestChannelImpl(String[] var1, boolean var2, String var3, String[] var4, boolean var5, String[] var6, boolean var7, String[] var8, Boolean var9, int var10, int var11, DateTime var12);

    public Flowable<EkoChannelEntity> getLatestChannel(String[] types, String userId, String[] memberships, String[] includingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce, DateTime now) {
        return this.getLatestChannelImpl(types, memberships.length > 0, userId, memberships, includingTags.length > 0, includingTags, excludingTags.length > 0, excludingTags, isDeleted, hash, nonce, now);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    abstract Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(String var1);

    public Flowable<EkoChannelEntity> getChannel(String channelId) {
        return this.getChannelImpl(channelId).map(input -> input);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = :channelId LIMIT 1")
    abstract EkoChannelWithMembershipAndExtra getByIdNowImpl(String var1);

    @Override
    public EkoChannelEntity getByIdNow(@NonNull String id) {
        return this.getByIdNowImpl(id);
    }

    @Query(value="SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (:ids)")
    abstract List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(List<String> var1);

    @Override
    @NonNull
    public List<EkoChannelEntity> getByIdsNow(@NonNull List<String> ids) {
        return FluentIterable.from(this.getByIdsNowImpl(ids)).transform((Function)new Function<EkoChannelWithMembershipAndExtra, EkoChannelEntity>(){

            @NullableDecl
            public EkoChannelEntity apply(@NullableDecl EkoChannelWithMembershipAndExtra input) {
                return input;
            }
        }).toList();
    }

    @Query(value="UPDATE channel set lastActivity = :lastActivity where channelId = :channelId")
    public abstract void updateLastActivity(String var1, DateTime var2);

    @Query(value="UPDATE channel set channelId = :channelId where channelId = :channelId")
    public abstract void updateUnreadCount(String var1);

    @Query(value="UPDATE channel set messageCount = :messageCount where channelId = :channelId and messageCount < :messageCount")
    public abstract void updateMessageCount(String var1, int var2);

    @Override
    @Query(value="DELETE from channel")
    public abstract void deleteAll();

    @Query(value="DELETE from channel where channelId = :channelId")
    abstract void deleteByIdImpl(String var1);

    @Transaction
    public void deleteById(String channelId) {
        this.deleteByIdImpl(channelId);
        this.messageDao.deleteAllFromChannel(channelId);
        this.channelMembershipDao.deleteAllFromChannel(channelId);
        this.channelExtraDao.deleteAllFromChannel(channelId);
    }

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = :userId)")
    public abstract Flowable<List<String>> getActiveIds(String var1);

    @Query(value="SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = :userId)")
    abstract List<String> getInactiveIds(String var1);

    @Transaction
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        List<String> inactiveChannelIds = this.getInactiveIds(AmityCoreClient.INSTANCE.getUserId());
        for (String inactiveChannelId : inactiveChannelIds) {
            this.deleteById(inactiveChannelId);
        }
        this.channelExtraDao.updateAllReadStatuses(EkoChannelReadStatus.NOT_READING);
    }

    private void beforeInsertOrUpdate(EkoChannelEntity channel) {
        EkoChannelEntity c = this.getByIdNow(channel.getChannelId());
        if (c != null) {
            channel.setMessageCount(Math.max(c.getMessageCount(), channel.getMessageCount()));
        }
    }

    private void beforeInsertOrUpdate(List<? extends EkoChannelEntity> cs) {
        for (EkoChannelEntity ekoChannelEntity : cs) {
            this.beforeInsertOrUpdate(ekoChannelEntity);
        }
    }

    @Override
    @Transaction
    public void insert(EkoChannelEntity channel) {
        this.beforeInsertOrUpdate(channel);
        super.insert(channel);
        EkoTagDao.update(channel, this.channelTagDao, EkoChannelTag::create);
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }

    @Override
    @Transaction
    public void insert(List<? extends EkoChannelEntity> channels) {
        this.beforeInsertOrUpdate(channels);
        super.insert(channels);
        EkoTagDao.update(channels, this.channelTagDao, EkoChannelTag::create);
        this.channelExtraDao.insertOrUpdate((List<String>)FluentIterable.from(channels).transform(channel -> channel.getChannelId()).toList());
    }

    @Override
    @Transaction
    public void update(EkoChannelEntity channel) {
        this.beforeInsertOrUpdate(channel);
        super.update(channel);
        EkoTagDao.update(channel, this.channelTagDao, EkoChannelTag::create);
        this.channelExtraDao.insertOrUpdate(channel.getChannelId());
    }
}

