/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.RoomDatabase;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.internal.data.RoomUtil;
import com.google.common.base.Preconditions;

abstract class BaseRoomDatabase
extends RoomDatabase {
    private static final RoomDatabase.Callback NO_CALLBACK = new RoomDatabase.Callback(){};

    BaseRoomDatabase() {
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, @NonNull boolean allowMainThreadQueries) {
        return BaseRoomDatabase.init(context, klass, name, database, allowMainThreadQueries, NO_CALLBACK);
    }

    static synchronized <T extends BaseRoomDatabase> T init(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name, @Nullable T database, @NonNull boolean allowMainThreadQueries, @NonNull RoomDatabase.Callback callback) {
        Context appContext = context.getApplicationContext();
        if (database == null) {
            Preconditions.checkNotNull((Object)callback, (Object)"RoomDatabase.Callback is null");
            RoomDatabase.Builder builder = RoomUtil.databaseBuilder(appContext, klass, name).addCallback(callback);
            if (allowMainThreadQueries) {
                builder.allowMainThreadQueries();
            }
            return (T)((Object)((BaseRoomDatabase)builder.build()));
        }
        String TAG = klass.getName();
        AmityLog.INSTANCE.tag(TAG).e("Database is not null (%s). Called init multiple times?", new Object[]{database});
        return database;
    }
}

