/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.init;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.google.common.base.Objects;
import hu.akarnokd.rxjava3.bridge.RxJavaBridge;
import io.reactivex.Flowable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import org.reactivestreams.Publisher;

class AmityChannelReader {
    private static Predicate<EkoMessageEntity> FILTER_MY_MESSAGE_OR_READING_CHANNEL = message -> {
        if (Objects.equal((Object)message.getUserId(), (Object)AmityCoreClient.INSTANCE.getUserId())) {
            return true;
        }
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        EkoChannelExtra extra = extraDao.getByIdNow(message.getChannelId());
        return extra != null && Objects.equal((Object)((Object)EkoChannelReadStatus.READING), (Object)((Object)extra.getReadStatus()));
    };
    private static BiFunction<EkoMessageEntity, EkoChannelExtra, EkoChannelExtra> SET_LOCAL_READ_TO_SEGMENT_FUNCTION = (msg, extra) -> {
        extra.setLocalReadToSegment(Math.max(extra.getLocalReadToSegment(), msg.getChannelSegment()));
        return extra;
    };

    private AmityChannelReader() {
    }

    private void start() {
        EkoAccountDao accountDao = EkoDatabase.get().accountDao();
        EkoChannelDao channelDao = UserDatabase.get().channelDao();
        EkoMessageDao messageDao = UserDatabase.get().messageDao();
        EkoChannelExtraDao extraDao = UserDatabase.get().channelExtraDao();
        CompositeDisposable latestMessageDisposable = new CompositeDisposable();
        accountDao.getCurrentAccountSingle().flatMapPublisher(account -> channelDao.getActiveIds(account.getUserId())).distinctUntilChanged().doOnNext(ids -> {
            latestMessageDisposable.clear();
            for (String id : ids) {
                latestMessageDisposable.add(RxJavaBridge.toV2Flowable(messageDao.getLatestMessage(id)).distinct(EkoMessageEntity::getChannelSegment).filter(FILTER_MY_MESSAGE_OR_READING_CHANNEL).flatMap(msg -> Flowable.zip((Publisher)Flowable.just((Object)msg), extraDao.getById(msg.getChannelId()), SET_LOCAL_READ_TO_SEGMENT_FUNCTION)).doOnNext(extraDao::update).subscribe());
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    static void init() {
        new AmityChannelReader().start();
    }
}

