/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.follow;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.follow.FollowLocalDataStore;
import com.amity.socialcloud.sdk.core.data.follow.FollowRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.follow.FollowRepository;
import com.amity.socialcloud.sdk.core.data.follow.info.MyFollowInfoModelMapper;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.user.AmityFollowRelationship;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatus;
import com.amity.socialcloud.sdk.core.user.AmityFollowStatusFilter;
import com.amity.socialcloud.sdk.core.user.AmityMyFollowInfo;
import com.amity.socialcloud.sdk.core.user.AmityUserFollowInfo;
import com.amity.socialcloud.sdk.social.data.follow.FollowRelationshipModelMapper;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoFollowListDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowersBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.boundarycallback.FollowingsBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoFollowDao;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.user.FollowerMediator;
import com.ekoapp.ekosdk.internal.repository.user.FollowingMediator;
import com.ekoapp.ekosdk.internal.repository.user.helper.MapToUserFollowStatusModelHelper;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00150\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00150\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006%"}, d2={"Lcom/amity/socialcloud/sdk/core/data/follow/FollowRepository;", "Lcom/ekoapp/ekosdk/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "Lcom/amity/socialcloud/sdk/core/user/AmityMyFollowInfo;", "()V", "acceptFollow", "Lio/reactivex/rxjava3/core/Completable;", "userId", "", "declineFollow", "fetchAndSave", "objectId", "getDefaultPageSize", "", "getFollowersPagedList", "Lio/reactivex/rxjava3/core/Flowable;", "Landroidx/paging/PagedList;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowRelationship;", "filter", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatusFilter;", "getFollowersPagingData", "Landroidx/paging/PagingData;", "getFollowingsPagedList", "getFollowingsPagingData", "getLatestFollower", "getLatestFollowing", "getUserFollowInfo", "Lcom/amity/socialcloud/sdk/core/user/AmityUserFollowInfo;", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "queryFromCache", "removeFollower", "requestFollow", "Lio/reactivex/rxjava3/core/Single;", "Lcom/amity/socialcloud/sdk/core/user/AmityFollowStatus;", "unfollow", "amity-sdk_release"})
public final class FollowRepository
extends AmityObjectRepository<EkoFollowCountEntity, AmityMyFollowInfo> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new FollowRemoteDataStore().getMyFollowInfo().flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"FollowRemoteDataStore().\u2026persist(it)\n            }");
        return completable;
    }

    @Override
    @Nullable
    public EkoFollowCountEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().getFollowCount(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EkoFollowCountEntity, AmityMyFollowInfo> mapper() {
        return new MyFollowInfoModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoFollowCountEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new FollowLocalDataStore().observeFollowCount(objectId);
    }

    @NotNull
    public final Flowable<AmityUserFollowInfo> getUserFollowInfo(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String myUserId = AmityCoreClient.INSTANCE.getUserId();
        Flowable flowable = new FollowRemoteDataStore().getUserFollowInfo(userId).flatMapCompletable((Function)getUserFollowInfo.1.INSTANCE).andThen((Publisher)Flowable.combineLatest((Publisher)((Publisher)new FollowLocalDataStore().observeUserFollow(myUserId, userId)), (Publisher)((Publisher)new FollowLocalDataStore().observeFollowCount(userId)), (BiFunction)getUserFollowInfo.2.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowRemoteDataStore().\u2026      }\n                )");
        return flowable;
    }

    @NotNull
    public final Single<AmityFollowStatus> requestFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Single single = new FollowRemoteDataStore().requestFollow(userId).map((Function)requestFollow.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"FollowRemoteDataStore().\u2026mOf(status)\n            }");
        return single;
    }

    @NotNull
    public final Completable acceptFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.ACCEPTED);
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)new FollowRemoteDataStore().acceptFollow(userId).flatMapCompletable((Function)acceptFollow.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.PENDING);
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable declineFollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable((Function)declineFollow.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.PENDING);
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable removeFollower(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)new FollowRemoteDataStore().declineFollow(userId).flatMapCompletable((Function)removeFollower.2.INSTANCE).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollower(this.$userId, AmityFollowStatus.ACCEPTED);
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Completable unfollow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = Completable.fromAction((Action)new Action(userId){
            final /* synthetic */ String $userId;

            public final void run() {
                new FollowLocalDataStore().updateFollowing(this.$userId, AmityFollowStatus.NONE);
            }
            {
                this.$userId = string;
            }
        }).concatWith((CompletableSource)new FollowRemoteDataStore().unfollow(userId).flatMapCompletable((Function)new Function<EkoFollowListDto, CompletableSource>(userId){
            final /* synthetic */ String $userId;

            public final CompletableSource apply(EkoFollowListDto it) {
                FollowLocalDataStore followLocalDataStore = new FollowLocalDataStore();
                EkoFollowCountEntity followCountEntity = followLocalDataStore.getFollowCountByIdNow(this.$userId);
                if (followCountEntity.getFollowingCount() != null) {
                    Integer n = followCountEntity.getFollowingCount();
                    Intrinsics.checkNotNull((Object)n);
                    if (n >= 0) {
                        Integer n2 = followCountEntity.getFollowingCount();
                        Intrinsics.checkNotNull((Object)n2);
                        followLocalDataStore.updateFollowingCount(this.$userId, n2 + -1);
                    }
                }
                return (CompletableSource)Completable.complete();
            }
            {
                this.$userId = string;
            }
        }).doOnError((Consumer)new Consumer<Throwable>(userId){
            final /* synthetic */ String $userId;

            public final void accept(Throwable it) {
                if (AmityError.Companion.from(it) == AmityError.ITEM_NOT_FOUND) {
                    new FollowLocalDataStore().updateFollowing(this.$userId, AmityFollowStatus.NONE);
                } else {
                    new FollowLocalDataStore().updateFollowing(this.$userId, AmityFollowStatus.ACCEPTED);
                }
            }
            {
                this.$userId = string;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.fromAction {\u2026     }\n                })");
        return completable;
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowingsPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        EkoFollowDao followDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followDao.getFollowingsDataSource(userId, filter);
        FollowingsBoundaryCallback boundaryCallback = new FollowingsBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new MapToUserFollowStatusModelHelper()), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowingsPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowingMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowingsPagingSource(this.$userId, this.$filter);
            }
            {
                this.$userId = string;
                this.$filter = amityFollowStatusFilter;
                super(0);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<PagedList<AmityFollowRelationship>> getFollowersPagedList(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        EkoFollowDao followerDao = UserDatabase.get().followDao();
        DataSource.Factory<Integer, EkoUserFollowStatusEntity> factory2 = followerDao.getFollowersDataSource(userId, filter);
        FollowersBoundaryCallback boundaryCallback = new FollowersBoundaryCallback(userId, filter, this.getDefaultPageSize());
        return RxJava3BridgeExtensionsKt.toV3(this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)new MapToUserFollowStatusModelHelper()), boundaryCallback));
    }

    @NotNull
    public final Flowable<PagingData<AmityFollowRelationship>> getFollowersPagingData(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new FollowerMediator(userId, filter), (Function0)new Function0<PagingSource<Integer, EkoUserFollowStatusEntity>>(userId, filter){
            final /* synthetic */ String $userId;
            final /* synthetic */ AmityFollowStatusFilter $filter;

            @NotNull
            public final PagingSource<Integer, EkoUserFollowStatusEntity> invoke() {
                return new FollowLocalDataStore().getFollowersPagingSource(this.$userId, this.$filter);
            }
            {
                this.$userId = string;
                this.$filter = amityFollowStatusFilter;
                super(0);
            }
        }, (ModelMapper)new FollowRelationshipModelMapper(), 2, null);
        return RxJava3BridgeExtensionsKt.toV3(pagerCreator2.create());
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollowing(userId, filter).map((Function)getLatestFollowing.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityFollowRelationship> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable flowable = new FollowLocalDataStore().getLatestFollower(userId, filter).map((Function)getLatestFollower.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"FollowLocalDataStore().g\u2026ipModelMapper().map(it) }");
        return flowable;
    }

    private final int getDefaultPageSize() {
        return 15;
    }
}

