/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.internal.data.model.EkoRoleObject;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName="community_role", primaryKeys={"communityId", "userId", "roleName"}, foreignKeys={@ForeignKey(entity=CommunityMembershipEntity.class, parentColumns={"communityId", "userId"}, childColumns={"communityId", "userId"}, onDelete=5)})
public class CommunityMembershipRoleEntity
extends EkoRoleObject {
    @NonNull
    private String communityId;
    @NonNull
    private String userId;
    @NonNull
    private String roleName;

    @NonNull
    public String getCommunityId() {
        return this.communityId;
    }

    public void setCommunityId(@NonNull String communityId) {
        this.communityId = EkoPreconditions.checkValidId(communityId, "communityId");
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(@NonNull String roleName) {
        this.roleName = EkoPreconditions.checkValidId(roleName, "roleName");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CommunityMembershipRoleEntity other = (CommunityMembershipRoleEntity)obj;
        return Objects.equal((Object)this.communityId, (Object)other.communityId) && Objects.equal((Object)this.userId, (Object)other.userId) && Objects.equal((Object)this.roleName, (Object)other.roleName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.communityId, this.userId, this.roleName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("communityId", (Object)this.communityId).add("userId", (Object)this.userId).add("roleName", (Object)this.roleName).toString();
    }

    public static CommunityMembershipRoleEntity create(@NonNull String communityId, @NonNull String userId, @NonNull String roleName) {
        CommunityMembershipRoleEntity communityRole = new CommunityMembershipRoleEntity();
        communityRole.setCommunityId(communityId);
        communityRole.setUserId(userId);
        communityRole.setRoleName(roleName);
        return communityRole;
    }
}

