/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import java.util.UUID;

@Entity(tableName="account")
public class EkoAccount {
    @PrimaryKey
    @NonNull
    private String userId;
    private String deviceId;
    private boolean isActive;
    private String refreshToken;
    private String accessToken;
    private String activationId = UUID.randomUUID().toString();

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (this.isActive) {
            this.activationId = UUID.randomUUID().toString();
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken2) {
        this.refreshToken = refreshToken2;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getActivationId() {
        return this.activationId;
    }

    public void setActivationId(String activationId) {
        this.activationId = activationId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userId", (Object)this.userId).add("deviceId", (Object)this.deviceId).add("isActive", this.isActive).add("refreshToken", (Object)this.refreshToken).add("accessToken", (Object)this.accessToken).add("activationId", (Object)this.activationId).toString();
    }

    public static EkoAccount create(@NonNull String userId) {
        EkoAccount account = new EkoAccount();
        account.setUserId(userId);
        account.setDeviceId((String)EkoAccountCache.getDeviceId().get());
        return account;
    }
}

